#include <iostream>
#include <fstream>
#include <sstream>
#include <iomanip>
#include <vector>
#include <string>
#include <unordered_set>
#include <algorithm>
#include <numeric>
#include <random>
#include <unistd.h>
#include <sys/signal.h>
using namespace std;

int main(int argc, const char *argv[]) {
	// We don't want the manager to die when a solution crashes and one of
	// the pipes closes...
	signal(SIGPIPE, SIG_IGN);

	// When the sandbox opens the other endpoints of these fifos to redirect
	// them to to stdin/out, it does so first for stdin and then for stdout.
	// We must match that order as otherwise we would deadlock.
	ofstream to_enc(argv[2]);
	ifstream from_enc(argv[1]);
	ofstream to_dec(argv[4]);
	ifstream from_dec(argv[3]);

	int m, n;
	cin >> m >> n;
	vector<int> train(n);
	for (auto & v : train) {
		cin >> v;
	}
	vector<int> data;
	for (int s; cin >> s; ) {
		data.push_back(s);
	}

	bool correct = true;
	int rcmd_count = 0;
	string diag;

	to_enc << "ENC" << endl;
	to_enc << m << ' ' << n << endl;
	for (int i = 0; i < n; ++i) {
		if (i > 0) to_enc << ' ';
		to_enc << train[i];
	}
	to_enc << endl;
	if (!to_enc) {
		diag = "Protocol error (encoding)";
		correct = false;
	}

	unordered_multiset<int> cars(train.begin(), train.end());

	vector<vector<int>> encoded;
	if (correct) {
		for (auto s : data) {
			to_enc << s << endl;
			if (!to_enc) {
				diag = "Protocol error (encoding)";
				correct = false;
				break;
			}

			string buf;
			getline(from_enc, buf);
			if (!from_enc) {
				diag = "Protocol error (encoding)";
				correct = false;
				break;
			}
			istringstream ss(buf);
			vector<int> v;
			for (int x; ss >> x; ) {
				v.push_back(x);
			}
			if (!ss.eof()) {
				diag = "Protocol error (encoding)";
				correct = false;
				break;
			}
			if (unordered_multiset<int>(v.begin(), v.end()) != cars) {
				diag = "Protocol error (encoding)";
				correct = false;
				break;
			}
			encoded.push_back(v);
		}
		to_enc << -1 << endl;
	}

	to_dec << "DEC" << endl;
	to_dec << m << ' ' << n << endl;
	if (!to_dec) {
		diag = "Protocol error (decoding)";
		correct = false;
	}

	if (correct) {
		vector<int> r(encoded.size());
		iota(r.begin(), r.end(), 0);
		std::random_device rd;
		std::mt19937 g(rd());
		g.seed(42);
		shuffle(r.begin(), r.end(), g);
		for (auto i : r) {
			for (int idx = 0; ; ++idx) {
				string buf;
				from_dec >> buf;
				if (!from_dec) {
					diag = "Protocol error (decoding)";
					correct = false;
					break;
				}
				if (buf == "R") {
					if (idx == n) {
						diag = "Protocol error (too may R commands)";
						correct = false;
						break;
					}
					to_dec << encoded[i][idx] << endl;
					if (!to_dec) {
						diag = "Protocol error (decoding)";
						correct = false;
						break;
					}
					rcmd_count += 1;
				} else {
					istringstream ss(buf);
					int u;
					ss >> u;
					if (!ss) {
						diag = "Protocol error (answer is not int)";
						correct = false;
						break;
					}
					if (u != data[i]) {
						diag = "Incorrect decode answer";
						correct = false;
					}
					break;
				}
			}
			if (!correct) {
				break;
			}
		}
	}

	to_dec << -1 << endl;
	if (!to_dec) {
		diag = "Protocol error (decoding)";
		correct = false;
	}

	// HACK: Wait a little so the solutions can exit. If the manager closes first,
	// the solution may receive SIGPIPE and die, and the CMS would not like that.
	usleep(10000);

	if (correct) {
		cout << fixed << setprecision(20) << 1.0 / max(1, rcmd_count) << endl;
		cerr << "OK, " << rcmd_count << " R-queries" << endl;
	} else {
		cout << 0 << endl;
		cerr << diag << endl;
	}
}
