#!/usr/bin/python3 -sS

import io
import sys
import random
import time

random.seed(42)

from_enc, to_enc, from_dec, to_dec = sys.argv[1:]

# When the sandbox opens the other endpoints of these fifos to redirect
# them to to stdin/out, it does so first for stdin and then for stdout.
# We must match that order as otherwise we would deadlock.
to_enc = io.open(to_enc, "wb", buffering=0)
from_enc = io.open(from_enc, "rb", buffering=0)
to_dec = io.open(to_dec, "wb", buffering=0)
from_dec = io.open(from_dec, "rb", buffering=0)

m, n = [int(x) for x in input().split()]
train = [int(x) for x in input().split()]
data = [int(x) for x in input().split()]

correct = True
rcmd_count = 0
diag = ""

try:
    to_enc.write(b"ENC\n")
    to_enc.write(b"%d %d\n" % (m, n))
    to_enc.write((' '.join(map(str, train)) + '\n').encode("ascii"))
except:
    diag = "Protocol error (encoding)"
    correct = False

train.sort()

encoded = []
if correct:
    for s in data:
        try:
            to_enc.write(b"%d\n" % s)
        except:
            diag = "Protocol error (encoding)"
            correct = False
            break
        try:
            v = from_enc.readline()
            x = [int(x) for x in v.decode("ascii").split()]
            if sorted(x) != train:
                diag = "Protocol error (encoding)"
                correct = False
                break
        except:
            diag = "Protocol error (encoding)"
            correct = False
            break
        encoded.append(x)
    try:
        to_enc.write(b"-1\n")
    except:
        diag = "Protocol error (encoding)"
        correct = False

try:
    to_dec.write(b"DEC\n")
    to_dec.write(b"%d %d\n" % (m, n))
except:
    diag = "Protocol error (decoding)"
    correct = False

if correct:
    r = list(range(len(encoded)))
    random.shuffle(r)
    for i in r:
        idx = 0
        while True:
            try:
                cmd = from_dec.readline().strip()
            except:
                diag = "Protocol error (decoding)"
                correct = False
                break
            if cmd == b'R':
                if idx == n:
                    diag = "Protocol error (too may R commands)"
                    correct = False
                    break
                try:
                    to_dec.write(b"%d\n" % encoded[i][idx])
                except:
                    diag = "Protocol error (decoding)"
                    correct = False
                    break
                rcmd_count += 1
                idx += 1
            else:
                try:
                    u = int(cmd)
                except:
                    diag = "Protocol error (answer is not int)"
                    correct = False
                    break
                if u != data[i]:
                    diag = "Incorrect decode answer"
                    correct = False
                break
        if not correct:
            break
try:
    to_dec.write(b"-1\n")
except:
    diag = "Protocol error (decoding)"
    correct = False

# HACK: Wait a little so the solutions can exit.
# If the manager closes first, the solution may receive SIGPIPE and die.
time.sleep(0.01)

if correct:
    a = 1 / max(1, rcmd_count)
    print(f"{a:.20f}")
    print(f"OK, {rcmd_count} R-queries", file=sys.stderr)
else:
    print(0)
    print(diag, file=sys.stderr)
