#!/usr/bin/env python3

# Input validator

import sys

st = set(range(1, 6))

fi = open(sys.argv[1], 'rt')
fo = open(sys.argv[2], 'wt')

m, n = [int(x) for x in fi.readline().split()]
if 0 >= m or m > 1e9:
    sys.exit('M out of range')
if 1 >= n or n > 1000:
    sys.exit('N out of range')
print(m, n, file=fo)

v = [int(x) for x in fi.readline().split()]
if len(v) != n:
    sys.exit('invalid length of V')
for i in range(n):
    if 0 > v[i] or v[i] > 1e9:
        sys.exit(f'V[{1 + i}] out of range')
print(*v, file=fo)

s = [int(x) for x in fi.readline().split()]
if len(s) > 1000:
    sys.exit('invalid length of S')
for i in range(len(s)):
    if 0 > s[i] or s[i] >= m:
        sys.exit('S[{1 + i}] out of range')
print(*s, file=fo)

if m != 2:
    st.discard(1)
if m >= n:
    st.discard(2)
if sorted(v) != list(range(1, 1 + n)):
    st.discard(3)
if len(set(v)) != n:
    st.discard(4)

fi.close()
fo.close()

if len(sys.argv) > 4 and sys.argv[4].startswith('-vv'):
    print(f'M = {m}, N = {n}, #S = {len(s)}')
if len(sys.argv) > 4 and sys.argv[4].startswith('-v'):
    print('subtasks:', *st)
