#!/usr/bin/python3


import sys
import math

from collections import Counter


def scale(x: int, m: int, n: int) -> int:
    if m == 1:
        return 0
    m_max = m - 1
    n_max = n - 1
    numerator = x * n_max + (m_max // 2)
    xx = numerator // m_max
    return max(0, min(n_max, xx))

def unscale(xx: int, m: int, n: int) -> int:
    
    if m == 1:
        return 0
    m_max = m - 1
    n_max = n - 1
    numerator = xx * m_max + (n_max // 2)
    x = numerator // n_max
    return max(0, min(m_max, x))


def factorial(n):
    r = 1
    for i in range(1,n+1):
        r = r * i
    return r


def multinomial_factor(n_remaining, counts):
    """
    Calculates the factor (n_remaining)! / (c1! * c2! * ... * ck!)
    where n_remaining is the total number of items left.
    counts is a dictionary of remaining counts for each distinct item.
    """
    if n_remaining == 0:
        return 1
    
    denominator = 1
    for count in counts.values():
        denominator *= factorial(count)
    
    # Handle the case where the denominator might be 0 due to
    # math.factorial(0) being 1, but we need to ensure the overall
    # calculation is correct. (n_remaining! / product of factorials)
    return factorial(n_remaining) // denominator


def count_permutations(inp):
    return multinomial_factor(len(inp),Counter(inp))

# --- RANK Function ---

def rank_permutation(permutation, initial_counts_map):
    """
    Calculates the lexicographical rank (0-indexed) of a permutation.
    :param permutation: The list/tuple representing the permutation (e.g., [2, 1, 3, 2, 1]).
    :param initial_counts_map: A Counter or dict of the original multiset counts (e.g., {1: 2, 2: 2, 3: 1}).
    :return: The rank (integer).
    """
    n = len(permutation)
    current_counts = initial_counts_map.copy()
    rank = 0

    # Get the sorted list of distinct items for iteration (e.g., [1, 2, 3])
    distinct_items = sorted(current_counts.keys())

    for i in range(n):
        pi_i = permutation[i]
        n_remaining = n - 1 - i
        
        # 1. Sum the contributions of items smaller than pi_i
        for j in distinct_items:
            # Check if j is smaller than the current element AND still available
            if j < pi_i and current_counts[j] > 0:
                
                # Calculate the factor for permutations starting with j
                # Temporarily decrement the count of j for the calculation
                current_counts[j] -= 1
                
                # Factor = (n_remaining)! / (counts after placing j)!
                # This is the number of permutations that start with the prefix up to i-1, followed by j.
                factor = multinomial_factor(n_remaining, current_counts)
                rank += factor
                
                # Restore the count of j
                current_counts[j] += 1
        
        # 2. Update counts by using the element pi_i
        if current_counts[pi_i] > 0:
            current_counts[pi_i] -= 1
        else:
            # Should not happen for a valid permutation of the multiset
            raise ValueError(f"Invalid permutation: Element {pi_i} at index {i} used too many times.")
            
    return rank

# --- UNRANK Function ---

def unrank_permutation(rank, initial_counts_map):
    """
    Reconstructs the permutation (0-indexed) corresponding to the given rank.
    :param rank: The rank (integer) to find the permutation for.
    :param initial_counts_map: A Counter or dict of the original multiset counts.
    :return: The permutation (list).
    """
    n = sum(initial_counts_map.values())
    current_counts = initial_counts_map.copy()
    
    # Ensure current_rank is mutable for subtraction
    current_rank = rank
    permutation = []
    
    # Get the sorted list of distinct items for iteration (e.g., [1, 2, 3])
    distinct_items = sorted(current_counts.keys())

    for i in range(n):
        n_remaining = n - 1 - i
        found_item = False
        
        for j in distinct_items:
            # Check if j is still available
            if current_counts[j] > 0:
                
                # Calculate the number of permutations that start with the next element j
                # Temporarily decrement the count of j
                current_counts[j] -= 1
                
                # Perms(j) = (n_remaining)! / (counts after placing j)!
                perms_j = multinomial_factor(n_remaining, current_counts)
                
                # Check if the current rank falls within the permutations starting with j
                if current_rank < perms_j:
                    # Found the correct element
                    permutation.append(j)
                    found_item = True
                    break # Break the inner loop (over distinct_items)
                else:
                    # The correct element is larger than j. Subtract and restore the count.
                    current_rank -= perms_j
                    current_counts[j] += 1 # Restore the count of j
        
        if not found_item:
            # This happens if the rank was too high (out of bounds)
            raise ValueError(f"Rank {rank} is too large for the multiset.")
            
    return permutation

def split_train(m, inp):
    f1 = []
    f2 = []
    perms = 1
    elem = 0
    mult = 1
    mset = Counter(inp)

    while True:
        for i in mset.keys():
            if mset[i] > 0:
                elem += 1
                perms = perms * elem
                perms = perms / mult
                f1.append(i)
                mset[i] -= 1
            if perms >= m: 
                break
        mult += 1
        if perms >= m:
            break
        if elem == len(inp):
            raise ValueError(f"Not enought permutations to encode value")
    for i in mset.keys():
        while mset[i] > 0:
            mset[i] -= 1
            f2.append(i)
    return(f1,f2)



def en():
    (m,n) = map(int,sys.stdin.readline().strip().split(' '))
    t = list(map(int,sys.stdin.readline().strip().split(' ')))

    t.sort()
    r = split_train(m,t)
    c = Counter(r[0]) 

    mm = count_permutations(r[0])  
    while True:
        s = int(sys.stdin.readline())
        if s == -1:
            exit(0)
        enc = unrank_permutation(scale(s,m,mm), c)
        print(' '.join(map(str,enc + r[1])),flush=True)


def de():
    (m,n) = map(int,sys.stdin.readline().strip().split(' '))
    a = None
    alen = None
    mm = None
    while True:
        perm = []
        while True:
            if a == None:
                print("R",flush=True)
                perm.append(int(sys.stdin.readline()))
                if perm[-1] == -1:
                    exit(0)
                if count_permutations(perm) < m:
                    continue
                a = Counter(perm)
                alen = len(perm)-1  
            
            else:
                for i in range(alen):
                    print("R",flush=True)
                    perm.append(int(sys.stdin.readline()))
                    if perm[-1] == -1:
                        exit(0)
                    #if i < alen-3:
                    #    continue

                    p1 = perm + sorted(list(a - Counter(perm)))
                    b1 = rank_permutation(p1,Counter(p1))
                    v1 = unscale(b1,m,mm)
                    if scale(v1,m,mm) < b1:
                        v1 = v1 + 1

                    p2 = perm + sorted(list(a - Counter(perm)),reverse=True)
                    b2 = rank_permutation(p2,Counter(p2))
                    v2 = unscale(b2,m,mm)
                    if scale(v2,m,mm) > b2:
                        v2 = v2 - 1
    
    
                    if v1 >= v2:
                        if v1 > 0 and unscale(v1 - 1 , m, mm ) >= b1:
                            continue
                        if (v2 < mm - 1) and unscale(v2 + 1, m, mm ) <= b2:
                            continue
                        perm += list(a - Counter(perm))
                        break

                    
                perm += list(a - Counter(perm))

            if mm == None:
                mm = count_permutations(perm) 
            v = unscale(rank_permutation(perm,Counter(perm)),m,mm)
            print(v, flush=True)
            break
            


        
    

mode = sys.stdin.readline().strip()

if mode == "ENC":
    en()
elif mode == "DEC":
    de()

