#define HIDE_CHECKER_OUTPUT
#include "testlib.h"
#include<iostream>
#include<vector>
#include<string>

using namespace std;

typedef long long ll;
const ll maxxy = 10000;
const ll maxabc = 100'000'000'000'000;

//utiil et leida kas punkt on vasakul või paremal pool sirget (või täpselt selle peal)
ll leftRight (pair<ll, ll> pt, vector<ll> line) {
    auto k = (-line[2] - line[0]*pt.first - line[1]*pt.second);
    if (k > 0) {
        return 1;
    }
    if (k < 0) {
        return -1;
    }
    return k;
}

bool checkLines(vector<pair<ll, ll>> pts, vector<vector<ll>> lines) {
    for (int i = 0; i < pts.size(); i++) {
        for (int j = i+1; j < pts.size(); j++) {
            bool separated = false;
            for (int k = 0; k < lines.size(); k++) {
                auto lr1 = leftRight(pts[i], lines[k]);
                auto lr2 = leftRight(pts[j], lines[k]);
                if (lr1 == 0 || lr2 == 0) { //ükski punkt ei tohiks olla sirge peal
                    return false;
                }
                if (lr1 != lr2) { //punktid on eri pool mingit sirget -> ok
                    separated = true;
                }
            }
            if (!separated) {
                return false;
            }
        }
    }
    return true;
}

int main(int argc, char **argv) {
    registerTestlibCmd(argc, argv);

    auto userAns = ouf.readString();
    auto realAns = ans.readString();
    if (userAns != realAns) {
        quit(_wa);
    }
    if (realAns == "EI") {
        quit(_ok);
    }

    vector<pair<ll, ll>> pts; //{x,y}
    for (int i = 0; i < 7; i++) {
        auto px = inf.readLong(-maxxy, maxxy);
        auto py = inf.readLong(-maxxy, maxxy);
        pts.push_back({px, py});
    }

    vector<vector<ll>> lines; //{a,b,c} kus ax + by + c = 0
    for (int i = 0; i < 3; i++) {
        auto la = ouf.readLong(-maxabc, maxabc);
        auto lb = ouf.readLong(-maxabc, maxabc);
        auto lc = ouf.readLong(-maxabc, maxabc);
        if (la == 0 && lb == 0) { //mõlemad a ja b ei tohi olla 0 korraga
            quit(_wa);
        }
        lines.push_back({la, lb, lc});
    }

    if (!checkLines(pts, lines)) {
        quit(_wa);
    }
    quit(_ok);
}
