import matplotlib.pyplot as plt
from pathlib import Path
import numpy as np

script_dir = Path(__file__).resolve().parent
n = 8 #change the testcase here
file_path = script_dir.parent / "input" / ("input" + str(n) + ".txt")

inp = open(file_path, "r")
points = [(int(i) for i in inp.readline().split()) for j in range(7)]
inp.close()

x, y = zip(*points)

# Line coefficients
a, b, c = 1, -1, 0   # x - y + 0 = 0  -> y = x
file_path = script_dir.parent / "output" / ("output" + str(n) + ".txt")
outp = open(file_path, "r")
exist = outp.readline()

colors = ["r", "g", "b"]
for j in range(0, 3):
    if (exist == "EI\n"):
        break
    a, b, c = (int(i) for i in outp.readline().split())

    x_line = np.linspace(min(x)-1, max(x)+1, 200)

    if b != 0:
        y_line = (-a * x_line - c) / b
        plt.plot(x_line, y_line, colors[j], label=f"{a}x + {b}y + {c} = 0")
    else:
        # vertical line: x = -c/a
        x_vertical = -c / a
        plt.axvline(x_vertical, color=colors[j], linestyle="-", label=f"{a}x + {b}y + {c} = 0")

plt.scatter(x, y, s=10, color="black")
plt.xlabel("x")
plt.ylabel("y")
plt.title("Lammaste visualisatsion")
plt.legend()
plt.show()
