from functools import cmp_to_key
import sys

def vadd (p, q):
    return (p[0] + q[0], p[1] + q[1])

def vsub (p, q):
    return (p[0] - q[0], p[1] - q[1])

def vmul (k, p):
    return (k * p[0], k * p[1])

def cross (p, q):
    return p[0] * q[1] - p[1] * q[0]

def dot (p, q):
    return p[0] * q[0] + p[1] * q[1]

def perp (p):
    return (-p[1], p[0])

def quadrant (p):
    if p == (0, 0):
        return 0

    if p[0] > 0 and p[1] >= 0:
        return 1

    if p[0] <= 0 and p[1] > 0:
        return 2

    if p[0] < 0 and p[1] <= 0:
        return 3

    if p[0] >= 0 and p[1] < 0:
        return 4

    assert False

class RadialComparator(tuple):
    def __lt__ (self, other):
        if quadrant(self) != quadrant(other):
            return quadrant(self) < quadrant(other)

        return cross(self, other) > 0
    
def main ():
    N = 7

    pts = []
    for i in range(N):
        x, y = map(int, input().split())
        pts.append((x, y))

    diffs = []
    for i in range(N):
        for j in range(N):
            if i == j:
                continue

            diff = vsub(pts[i], pts[j])
            if diff == (0, 0):
                print("EI")
                return

            diffs.append(diff)

    diffs.sort(key=RadialComparator)

    dirs = []
    for i in range(len(diffs)):
        a = diffs[i]
        b = diffs[(i + 1) % len(diffs)]

        if cross(a, b) == 0:
            if dot(a, b) < 0:
                # opposite direction
                dirs.append(perp(a))
        else:
            dirs.append(vadd(a, b))

    lines = []
    for dir in dirs:
        cs = []
        for i in range(N):
            cs.append(dot(perp(dir), pts[i]))

        cs.sort()
        for i in range(len(cs) - 1):
            if cs[i] == cs[i + 1]:
                continue

            lines.append((vmul(2, perp(dir)), -(cs[i] + cs[i + 1])))

    for i in range(len(lines)):
        for j in range(i + 1, len(lines)):
            for k in range(j + 1, len(lines)):
                cnt = [0] * 8

                for p in range(N):
                    mask = 0
                    mask |= dot(lines[i][0], pts[p]) + lines[i][1] > 0
                    mask |= (dot(lines[j][0], pts[p]) + lines[j][1] > 0) << 1
                    mask |= (dot(lines[k][0], pts[p]) + lines[k][1] > 0) << 2
                    cnt[mask] += 1

                if max(cnt) <= 1:
                    print("JAH")
                    print(lines[i][0][0], lines[i][0][1], lines[i][1])
                    print(lines[j][0][0], lines[j][0][1], lines[j][1])
                    print(lines[k][0][0], lines[k][0][1], lines[k][1])
                    return

    print("EI")

if __name__ == "__main__":
    main()
