#include<iostream>
#include<vector>
#include<string>
#include<fstream>

using namespace std;

typedef long long int ll;

//utiil et leida kas punkt on vasakul või paremal pool sirget (või täpselt selle peal)
ll leftRight (pair<ll, ll> pt, vector<ll> line) {
    ll k = line[2] + line[0]*pt.first + line[1]*pt.second;
    if (k > 0) {
        return 1;
    }
    if (k < 0) {
        return -1;
    }
    return k;
}

bool checkLines(vector<pair<ll, ll>> pts, vector<vector<ll>> lines) {
    for (ll i = 0; i < pts.size(); i++) {
        for (ll j = i+1; j < pts.size(); j++) {
            bool onLine = false;
            bool separated = false;
            for (ll k = 0; k < lines.size(); k++) {
                ll lr1 = leftRight(pts[i], lines[k]);
                ll lr2 = leftRight(pts[j], lines[k]);
                if (lr1 == 0 || lr2 == 0) { //ükski punkt ei tohiks olla sirge peal
                    onLine = true;
                    break;
                }
                if (lr1 != lr2) { //punktid on eri pool mingit sirget -> ok
                    separated = true;
                }
            }
            if (!separated || onLine) {
                return false;
            }
        }
    }
    return true;
}


int main() {
    vector<pair<ll, ll>> pts;
    for (ll i = 0; i < 7; i++) {
        ll px = 0; ll py = 0; cin >> px >> py;
        pts.push_back({px, py});
    }

    vector<vector<ll>> candidates = {}; //kandidaat-sirged (peavad jaotama 7 -> 4+3)
    string ans = "EI";
    vector<vector<ll>> ansLines;

    for (ll i = 0; i < pts.size(); i++) {
        for (ll j = i+1; j < pts.size(); j++) { //käime üle punktide paaride
            pair<ll, ll> pt1 = pts[i];
            pair<ll, ll> pt2 = pts[j];
            //konstrueerime sirge, mis läbib antud punktide paari
            vector<ll> baseline = {pt2.second-pt1.second, -(pt2.first-pt1.first), 0};
            baseline[2] = -(baseline[0]*pt1.first + baseline[1]*pt1.second);

            //võrdleme kas ülejäänud punktid on vasakul või paremal
            ll leftCount = 0;
            ll rightCount = 0;
            for (ll k = 0; k < pts.size(); k++) {
                ll lr = leftRight(pts[k], baseline);
                if (lr == 1) {leftCount += 1;}
                if (lr == -1) {rightCount += 1;}
            }
            //nihutame sirge veidi kõrvale (et see ei läbiks algseid punkte)
            ll extra = 25000; //peab olema > x_i vahemik (ülesandes 20 000)
            if ((leftCount <= 1 && rightCount == 4) || (leftCount >= 1 && leftCount <= 2 && rightCount == 3)) { //2 või 3 sirgel olevat punkti peab panema vasakule
                candidates.push_back({baseline[0]*extra, baseline[1]*extra, baseline[2]*extra+1});
            }
            if ((leftCount == 4 && rightCount <= 1) || (leftCount == 3 && rightCount >= 1 && rightCount <= 2)) {
                candidates.push_back({baseline[0]*extra, baseline[1]*extra, baseline[2]*extra-1});
            }
        }
    }

    for (ll i = 0; i < candidates.size(); i++) {
        for (ll j = i+1; j < candidates.size(); j++) {
            for (ll k = j+1; k < candidates.size(); k++) {
                bool valid = checkLines(pts, {candidates[i], candidates[j], candidates[k]});
                if (valid) {
                    ans = "JAH";
                    ansLines = {candidates[i], candidates[j], candidates[k]};
                }
            }
        }
    }
    cout << ans << endl;
    for (ll i = 0; i < ansLines.size(); i++) {
        cout << ansLines[i][0] << " " << ansLines[i][1] << " " << ansLines[i][2] << endl;
    }
}
