#include <cstdint>
#include "testlib.h"
#include <set>

using namespace std;

int main (int argc, char **argv) {
  registerGen(argc, argv, 1);

  int n = opt<int>("n");
  int lcap = opt<int>("lcap");
  int q = opt<int>("q");

  int m = (n * (n - 1)) / 2;

  cout << n << " " << m << " " << q << '\n';
  for (int i = 1; i <= n; i++) {
    for (int j = i + 1; j <= n; j++) {
      cout << i << " " << j << " " << rnd.next(1, lcap) << '\n';
    }
  }

  vector<int> qs (q - 2 * n, -1);
  for (int i = 1; i <= n; i++)
    for (int k = 0; k < 2; k++)
      qs.push_back(i);

  shuffle(qs.begin(), qs.end());

  set<int> seen;
  for (int q : qs) {
    if (q == -1) {
      int u, v;
      do {
        u = rnd.next(1, n);
        v = rnd.next(1, n);
      } while (u == v);

      cout << "? " << u << " " << v << '\n';
    } else if (seen.count(q)) {
      cout << "+ " << q << '\n';
    } else {
      seen.insert(q);
      cout << "- " << q << '\n';
    }
  }
}
