#!/usr/bin/env python3

# Input validator

import sys

st = set(range(1, 5))

fi = open(sys.argv[1], 'rt')
fo = open(sys.argv[2], 'wt')

n, m, q = [int(v) for v in fi.readline().split()]
if 2 > n or n > 350:
    sys.exit(f'N out of range')
if n - 1 > m or m > n * (n - 1) / 2:
    sys.exit(f'M out of range')
if 1 > q or q > 1e6:
    sys.exit(f'Q out of range')
fo.write(f'{n} {m} {q}\n')
if n > 60:
    st.discard(1)

e = set()
for i in range(m):
    u, v, l = [int(v) for v in fi.readline().split()]
    if 1 > u or u > n:
        sys.exit(f'U[{1 + i}] out of range')
    if 1 > v or v > n:
        sys.exit(f'V[{1 + i}] out of range')
    if u == v:
        sys.exit(f'U[{1 + i}] = V[{1 + i}]')
    if (min(u, v), max(u, v)) in e:
        sys.exit(f'Duplicate street {u}-{v}')
    if 1 > l or l > 1e9:
        sys.exit(f'L[{1 + i}] out of range')
    fo.write(f'{u} {v} {l}\n')
    e.add((min(u, v), max(u, v)))
#TODO: connectedness
    
q1 = set()
q2 = set()
for i in range(q):
    s = fi.readline().split()
    if s[0] == '-':
        u = int(s[1])
        if 1 > u or u > n:
            sys.exit(f'U out of range in Q[{1 + i}]')
        if u in q1:
            sys.exit(f'Repeated closure of {u} in Q[{1 + i}]')
        fo.write(f'- {u}\n')
        q1.add(u)
        st.discard(2)
    elif s[0] == '+':
        u = int(s[1])
        if 1 > u or u > n:
            sys.exit(f'U out of range in Q[{1 + i}]')
        if u not in q1:
            sys.exit(f'{u} not closed in Q[{1 + i}]')
        if u in q2:
            sys.exit(f'{u} already reopened in Q[{1 + i}]')
        fo.write(f'+ {u}\n')
        q2.add(u)
        if i < n:
            st.discard(3)
    elif s[0] == '?':
        u, v = int(s[1]), int(s[2])
        if 1 > u or u > n:
            sys.exit(f'U out of range in Q[{1 + i}]')
        if 1 > v or v > n:
            sys.exit(f'V out of range in Q[{1 + i}]')
        if u == v:
            sys.exit(f'U = V in Q[{1 + i}]')
        fo.write(f'? {u} {v}\n')
        if i < n:
            st.discard(3)

fi.close()
fo.close()

if len(sys.argv) > 4 and sys.argv[4] == '-v':
	print('subtasks:', *st)
