#include <cstdint>
#include "testlib.h"
#include <set>
#include <numeric>

using namespace std;

class DSU {
  vector<int> root;

public:
  DSU (int _n) : root(_n) {
    iota(root.begin(), root.end(), 0);
  }

  int find (int u) {
    if (u != root[u]) {
      root[u] = find(root[u]);
    }
    return root[u];
  }

  void merge (int u, int v) {
    u = find(u);
    v = find(v);

    if (u == v) {
      return;
    }

    root[v] = u;
  }
};

int main (int argc, char **argv) {
  registerValidation(argc, argv);

  int n = inf.readInt(1, 350, "n");
  inf.readSpace();
  int m = inf.readInt(n - 1, (n * (n - 1)) / 2, "m");
  inf.readSpace();
  int q = inf.readInt(1, 1'000'000, "q");
  inf.readEoln();

  DSU dsu (n + 1);
  set<pair<int, int>> edges;
  for (int i = 0; i < m; i++) {
    int u = inf.readInt(1, n, "u");
    inf.readSpace();
    int v = inf.readInt(1, n, "v");
    inf.readSpace();
    inf.readInt(1, 1'000'000'000, "L");
    inf.readEoln();

    auto e = make_pair(min(u, v), max(u, v));
    ensuref(!edges.count(e), "duplicate edge defined on line %d", i);
    edges.insert(e);

    ensuref(u != v, "self-loop defined on line %d", i);
    dsu.merge(u, v);
  }

  for (int i = 1; i <= n; i++)
    ensuref(dsu.find(i) == dsu.find(1), "graph is not connected");

  set<int> cur_removed;
  set<int> ever_removed;
  int remove_count = 0, remove_prefix = 0, ask_count = 0;
  for (int i = 0; i < q; i++) {
    string type = inf.readToken();
    inf.readSpace();
    int u = inf.readInt(1, n, "u");
    
    if (type == "-") {
      ensuref(!ever_removed.count(u),
              "attempt to remove vertex %d but it has been removed before in the test", u);
      cur_removed.insert(u);
      ever_removed.insert(u);

      remove_count++;
      if (i == remove_prefix)
        remove_prefix++;
    } else if (type == "+") {
      ensuref(cur_removed.count(u), "attempt to add vertex %d but it has not been removed", u);
      cur_removed.erase(u);
    } else if (type == "?") {
      inf.readSpace();
      int v = inf.readInt(1, n, "v");

      ensuref(u != v, "u and v identical in query on line %d", i);
      ask_count++;
    } else {
      ensuref(false, "unknown query type");
    }

    inf.readEoln();
  }
  
  inf.readEof();

  ensuref(ask_count > 0, "input must contain at least one '?' query");

  if (validator.group() == "small-n")
    ensure(n <= 60);
  if (validator.group() == "noremove")
    ensure(remove_count == 0);
  if (validator.group() == "prefremove")
    ensure(remove_prefix == n);
}
