// N Floyd-Warshalls but floyd-warshall in the wrong order
// WA

#include <iostream>
#include <vector>

using namespace std;

typedef long long ll;

const ll INF = 1e18;

vector<vector<ll>> fw (vector<vector<ll>> conn, vector<int> alive) {
  int n = conn.size();
  for (int i = 0; i < n; i++) {
    for (int j = 0; j < n; j++)
      for (int k = 0; k < n; k++)
        if (alive[k])
          conn[i][j] = min(conn[i][j], conn[i][k] + conn[k][j]);
  }

  return conn;
}

int main () {
  ios::sync_with_stdio(false);
  cin.tie(0);

  int n, m, qc;
  cin >> n >> m >> qc;

  vector<vector<ll>> conn (n, vector<ll> (n, INF));
  for (int i = 0; i < n; i++)
    conn[i][i] = 0;

  for (int i = 0; i < m; i++) {
    int u, v, w;
    cin >> u >> v >> w;
    u--; v--;

    conn[u][v] = w;
    conn[v][u] = w;
  }

  vector<int> alive (n, 1);
  auto cur = fw(conn, alive);
  
  for (int i = 0; i < qc; i++) {
    char type;
    cin >> type;

    if (type == '-' || type == '+') {
      int u;
      cin >> u;
      u--;

      alive[u] = type == '+';
      cur = fw(conn, alive);
    } else {
      int u, v;
      cin >> u >> v;
      u--; v--;

      if (cur[u][v] == INF)
        cout << -1 << '\n';
      else
        cout << cur[u][v] << '\n';
    }
  }
}
