import sys

INF = 10**18

class NotifTree:
    def __init__ (self, queries, conn):
        self.n = 1
        self.queries = queries
        self.vc = len(conn)
        self.conn = conn

        while self.n < len(queries):
            self.n *= 2

        self.notifs = [[] for _ in range(2 * self.n)]
        self.lfend = [i - self.n for i in range(2 * self.n)]
        self.rgend = [i - self.n + 1 for i in range(2 * self.n)]

        for i in range(self.n - 1, 0, -1):
            self.lfend[i] = self.lfend[2 * i]
            self.rgend[i] = self.rgend[2 * i + 1]

        self.dist_stk = [[row[:] for row in conn]]

    def put (self, ql, qr, x, u = 1):
        ql = max(ql, self.lfend[u])
        qr = min(qr, self.rgend[u])

        if ql >= qr:
            return

        if ql == self.lfend[u] and qr == self.rgend[u]:
            self.notifs[u].append(x)
            return

        self.put(ql, qr, x, 2 * u)
        self.put(ql, qr, x, 2 * u + 1)

    def push (self, k):
        nxt = [row[:] for row in self.dist_stk[-1]]

        for i in range(self.vc):
            for j in range(self.vc):
                nxt[i][j] = min(nxt[i][j], nxt[i][k] + nxt[k][j])

        self.dist_stk.append(nxt)

    def pop (self):
        self.dist_stk.pop()

    def dfs (self, u):
        for k in self.notifs[u]:
            self.push(k)

        if u < self.n:
            self.dfs(2 * u)
            self.dfs(2 * u + 1)
        elif u - self.n < len(self.queries):
            for a, b in self.queries[u - self.n]:
                ans = self.dist_stk[-1][a][b]
                if ans == INF:
                    ans = -1
                sys.stdout.write(str(ans) + "\n")

        for k in self.notifs[u]:
            self.pop()

def main ():
    n, m, qc = map(int, sys.stdin.readline().strip().split())
    conn = [[0 if i == j else INF for j in range(n)] for i in range(n)]

    for i in range(m):
        u, v, w = map(int, sys.stdin.readline().strip().split())
        u -= 1
        v -= 1

        conn[u][v] = w
        conn[v][u] = w

    dead_sta = [-1] * n
    dead_end = [-1] * n
    queries_at = [[]]

    for i in range(qc):
        tokens = sys.stdin.readline().strip().split()
        u = int(tokens[1]) - 1

        if tokens[0] == "-":
            dead_sta[u] = len(queries_at)
            queries_at.append([])
        elif tokens[0] == "+":
            dead_end[u] = len(queries_at)
            queries_at.append([])
        else:
            v = int(tokens[2]) - 1
            queries_at[-1].append((u, v))

    tree = NotifTree(queries_at, conn)
    for u in range(n):
        if dead_sta[u] != -1:
            tree.put(0, dead_sta[u], u)
        else:
            tree.put(0, tree.n, u)
            
        if dead_end[u] != -1:
            tree.put(dead_end[u], tree.n, u)

    tree.dfs(1)

if __name__ == "__main__":
    main()
