// full solution but prints INF instead of -1
// 0 points

#include <iostream>
#include <vector>

using namespace std;

typedef long long ll;

const ll INF = 1e18;

struct NotifTree {
  int n;
  vector<vector<pair<int, int>>> queries;
  vector<vector<int>> notifs;
  vector<int> lfend;
  vector<int> rgend;

  int vc;
  vector<vector<ll>> conn;
  vector<vector<vector<ll>>> dist_stk;

  NotifTree (vector<vector<pair<int, int>>> _queries, vector<vector<ll>> _conn)
    : n(1), queries(_queries), vc(_conn.size()), conn(_conn) {
    while (n < (int) queries.size())
      n *= 2;

    notifs = vector<vector<int>> (2 * n, vector<int> (0));
    lfend = vector<int> (2 * n);
    rgend = vector<int> (2 * n);

    for (int i = n; i < 2 * n; i++) {
      lfend[i] = i - n;
      rgend[i] = i - n + 1;
    }

    for (int i = n - 1; i > 0; i--) {
      lfend[i] = lfend[2 * i];
      rgend[i] = rgend[2 * i + 1];
    }

    dist_stk = vector<vector<vector<ll>>> (1, conn);
    for (int i = 0; i < vc; i++)
      dist_stk[0][i][i] = 0;
  }

  void put (int ql, int qr, int x, int u = 1) {
    ql = max(ql, lfend[u]);
    qr = min(qr, rgend[u]);

    if (ql >= qr)
      return;

    if (ql == lfend[u] && qr == rgend[u]) {
      notifs[u].push_back(x);
      return;
    }

    put(ql, qr, x, 2 * u);
    put(ql, qr, x, 2 * u + 1);
  }

  void push (int k) {
    // cerr << "PUSH " << k << endl;
    vector<vector<ll>> nxt = dist_stk.back();

    for (int i = 0; i < vc; i++)
      for (int j = 0; j < vc; j++)
        nxt[i][j] = min(nxt[i][j], nxt[i][k] + nxt[k][j]);

    dist_stk.push_back(nxt);
  }

  void pop (int k) {
    // cerr << "POP " << k << endl;
    dist_stk.pop_back();
  }

  void dfs (int u) {
    for (int k : notifs[u])
      push(k);

    if (u < n) {
      dfs(2 * u);
      dfs(2 * u + 1);
    } else if (u - n < (int) queries.size()) {
      for (auto uv : queries[u - n]) {
        ll ans = dist_stk.back()[uv.first][uv.second];
        cout << ans << '\n';
      }

    }
      
    for (int k : notifs[u])
      pop(k);
  }
};

int main () {
  ios::sync_with_stdio(false);
  cin.tie(0);
  
  int n, m, qc;
  cin >> n >> m >> qc;

  vector<vector<ll>> conn (n, vector<ll> (n, INF));
  for (int i = 0; i < n; i++) {
    conn[i][i] = 0;
  }

  for (int i = 0; i < m; i++) {
    int u, v, w;
    cin >> u >> v >> w;
    u--; v--;
    
    conn[u][v] = w;
    conn[v][u] = w;
  }

  vector<int> dead_sta (n, -1), dead_end (n, -1);
  vector<vector<pair<int, int>>> queries_at (1, vector<pair<int, int>> (0));

  for (int i = 0; i < qc; i++) {
    char type;
    cin >> type;

    int u;
    cin >> u;
    u--;

    if (type == '-') {
      dead_sta[u] = queries_at.size();
      queries_at.push_back(vector<pair<int, int>> (0));
    } else if (type == '+') {
      dead_end[u] = queries_at.size();
      queries_at.push_back(vector<pair<int, int>> (0));
    } else {
      int v;
      cin >> v;
      v--;
      
      queries_at.back().emplace_back(u, v);
    }
  }

  // a vertex "exists" at the range [0, dead_sta[u]) and [dead_end[u], oo)
  NotifTree tree (queries_at, conn);
  for (int u = 0; u < n; u++) {
    if (dead_sta[u] != -1)
      tree.put(0, dead_sta[u], u);
    else
      tree.put(0, tree.n, u);
    
    if (dead_end[u] != -1)
      tree.put(dead_end[u], tree.n, u);
  }

  tree.dfs(1);
}
