// incremental floyd-warshall
// assume that all "remove" queries are either at the beginning or don't exist
// two middle subtasks

#include <iostream>
#include <vector>

using namespace std;

typedef long long ll;

const ll INF = 1e18;

int main () {
  ios::sync_with_stdio(false);
  cin.tie(0);

  int n, m, qc;
  cin >> n >> m >> qc;

  vector<vector<ll>> conn (n, vector<ll> (n, INF));
  for (int i = 0; i < n; i++)
    conn[i][i] = 0;
  
  for (int i = 0; i < m; i++) {
    int u, v, w;
    cin >> u >> v >> w;
    u--; v--;

    conn[u][v] = w;
    conn[v][u] = w;
  }

  bool init_mode = true;
  vector<int> alive (n, 1);
  for (int t = 0; t < qc; t++) {
    char type;
    cin >> type;

    int u;
    cin >> u;
    u--;
    
    if (type == '-') {
      if (init_mode)
        alive[u] = 0;
    } else {
      if (init_mode) {
        for (int k = 0; k < n; k++)
          if (alive[k])
            for (int i = 0; i < n; i++)
              for (int j = 0; j < n; j++)
                conn[i][j] = min(conn[i][j], conn[i][k] + conn[k][j]);
        
        init_mode = 0;
      }

      if (type == '+') {
        for (int i = 0; i < n; i++)
          for (int j = 0; j < n; j++)
            conn[i][j] = min(conn[i][j], conn[i][u] + conn[u][j]);
      } else {
        int v;
        cin >> v;
        v--;

        cout << (conn[u][v] == INF ? -1 : conn[u][v]) << '\n';
      }
    }
  }
}
