import sys

INF = 10**18

def fw (conn, alive):
    n = len(conn)
    conn = [row[:] for row in conn]
    for k in range(n):
        if not alive[k]:
            continue

        for i in range(n):
            for j in range(n):
                conn[i][j] = min(conn[i][j], conn[i][k] + conn[k][j])
    return conn

def main ():
    n, m, qc = map(int, sys.stdin.readline().strip().split())
    conn = [[0 if i == j else INF for j in range(n)] for i in range(n)]
    for i in range(m):
        u, v, w = map(int, sys.stdin.readline().strip().split())
        u -= 1
        v -= 1
        conn[u][v] = w
        conn[v][u] = w

    alive = [1] * n
    cur = fw(conn, alive)

    for i in range(qc):
        tokens = sys.stdin.readline().strip().split()

        if tokens[0] == "-" or tokens[0] == "+":
            u = int(tokens[1]) - 1
            alive[u] = tokens[0] == "+"
            cur = fw(conn, alive)
        else:
            u = int(tokens[1]) - 1
            v = int(tokens[2]) - 1
            ans = cur[u][v] if cur[u][v] < INF else -1
            sys.stdout.write(str(ans) + "\n")
    
if __name__ == "__main__":
    main()
