#include "testlib.h"
#include <sstream>
#include <optional>
#include <map>
#include <set>
#include <cassert>
#include <cctype>
#include <algorithm>

using namespace std;

vector<string> readTokens (InStream &in) {
  string line = in.readLine();
  auto lstream = istringstream(line);

  vector<string> out;
  string token;
  while (lstream >> token)
    out.push_back(token);

  return out;
}

int nearest_five (int n) {
  if (n % 5 == 0) return n;
  if (n % 5 == 1) return n - 1;
  if (n % 5 == 2) return n - 2;
  if (n % 5 == 3) return n + 2;
  if (n % 5 == 4) return n + 1;
  assert(false);
}

pair<int, optional<string>> readAns (InStream &in, map<string, int> &prices) {
  int euros = in.readInt();
  int cents = in.readInt(0, 99);

  optional<string> error = nullopt;
  
  if (!in.seekEoln()) {
    error = string("extra data on first line");
    return make_pair(100 * euros + cents, error);
  }
  
  vector<vector<string>> groups;
  while (!in.seekEof()) {
    auto group = readTokens(in);
    groups.push_back(group);
  }

  set<string> seen_items;
  int actual_price = 0;
  for (auto group : groups) {
    int cur_price = 0;
    for (auto item : group) {
      if (!prices.count(item)) {
        error = string("unknown item in purchase list");
      } else {
        if (seen_items.count(item))
          error = string("item purchased multiple times");

        seen_items.insert(item);
        cur_price += prices[item];
      }
    }

    cur_price = nearest_five(cur_price);
    actual_price += cur_price;
  }

  if (seen_items.size() != prices.size())
    error = string("not all items have been purchased");
  
  if (actual_price != 100 * euros + cents)
    error = string("actual price doesn't match stated price");

  return make_pair(100 * euros + cents, error);
}

int main (int argc, char **argv) {
  registerTestlibCmd(argc, argv);

  int n = inf.readInt();
  map<string, int> prices;
  for (int i = 0; i < n; i++) {
    string name = inf.readToken();
    int euros = inf.readInt();
    int cents = inf.readInt();

    prices[name] = 100 * euros + cents;
  }

  auto ja = readAns(ans, prices);
  auto pa = readAns(ouf, prices);

  if (ja.second)
    quitf(_fail, "jury solution is broken");

  if (pa.second) {
    if (ja.first == pa.first)
      quitp(0.5, string("sum is correct but output is not (") + pa.second.value() + ")");

    quitf(_wa, pa.second.value().c_str());
  }

  if (ja.first > pa.first)
    quitf(_fail, "participant has better solution than jury");

  if (ja.first < pa.first)
    quitf(_wa, "sum is not optimal");

  quitf(_ok, "OK");
}
