#!/usr/bin/env python3

# Input validator

import sys
import re

id = re.compile('[a-z]{1,20}')

st = set(range(1, 8))

fi = open(sys.argv[1], 'rt')
fo = open(sys.argv[2], 'wt')

n = int(fi.readline().strip())
if 1 > n or n > 1e5:
    sys.exit(f'N out of range')
fo.write(f'{n}\n')
if n > 3:
    st.discard(1)
if n > 6:
    st.discard(5)
if n > 100:
    st.discard(6)

names = set()
for i in range(n):
    t, e, s = fi.readline().split()
    e, s = int(e), int(s)
    if not id.match(t):
        sys.exit(f'Invalid T[{1 + i}]')
    if 0 > e or e > 100:
        sys.exit(f'E[{1 + i}] out of range')
    if 0 > s or s > 99:
        sys.exit(f'S[{1 + i}] out of range')
    fo.write(f'{t} {e} {s}\n')
    if s > 2:
        st.discard(2)
    if s % 10 not in [0, 1, 2, 5, 6, 7]:
        st.discard(3)
    if s != 99:
        st.discard(4)
    names.add(t)
if len(names) != n:
    sys.exit(f'T[i] not unique')

fi.close()
fo.close()

# note: second condition of subtask 7 not verified

if len(sys.argv) > 4 and sys.argv[4] == '-v':
    print('subtasks:', *st)
