#!/usr/bin/env python3

# Input validator

import sys
import re

id = re.compile('[a-z]{1,20}')

st = set(range(1, 7))

fi = open(sys.argv[1], 'rt')
fo = open(sys.argv[2], 'wt')

n = int(fi.readline().strip())
if 1 > n or n > 1e5:
    sys.exit(f'N out of range')
fo.write(f'{n}\n')
if n != 3:
    st.discard(1)
if n > 2500:
    st.discard(5)

scores = set()
lastp = 1e9
for i in range(n):
    s, p = fi.readline().split()
    if not id.match(s):
        sys.exit(f'Invalid S[{1 + i}]')
    p = int(p)
    if 0 > p or p > 1e9:
        sys.exit(f'P[{1 + i}] out of range')
    fo.write(f'{s} {p}\n')
    if p > 10:
        st.discard(2)
    scores.add(p)
    if p > lastp:
        st.discard(4)
    lastp = p
if len(scores) != n:
    st.discard(3)

fi.close()
fo.close()

if len(sys.argv) > 4 and sys.argv[4] == '-v':
	print('subtasks:', *st)
