// ebaefektiivne lahendus tulemuste nimekirja korduva läbikammimise abil
// kasutab käsitsi kirjutatud kordusi

#include <iostream>
#include <string>
#include <vector>
#include <utility>
using namespace std;

int main() {
	// loeme osalejate arvu
	int n;
	cin >> n;

	// teeme loendi, mille elemendid on punktisumma/kasutajanimi paarid
	vector<pair<int, string>> tabel(n);
	for (auto & [p, s] : tabel) {
		// loeme osaleja nime ja punktisumma
		cin >> s >> p;
	}

	int koht = 1; // alustame 1. koha väljastamisest

	// kuni on veel osalejaid, leiame ja väljastame suurima punktisummaga grupi
	while (tabel.size() > 0) {
		// esimese läbimisega leiame suurima punktisumma
		int skoor = -1; // väiksem kui ükski sisendis olev punktisumma
		for (const auto & [p, s] : tabel) {
			if (p > skoor) {
				skoor = p;
			}
		}

		// teise läbimisega leiame selle punktisummaga osalejate grupi
		vector<string> grupp;
		for (const auto & [p, s] : tabel) {
			if (p == skoor) {
				grupp.push_back(s);
			}
		}

		// väljastame osalejate grupi
		const int suurus = grupp.size();
		for (const auto & s : grupp) {
			if (suurus == 1) {
				// kui grupis on üks osaleja, siis kohtade jagamist ei ole
				cout << koht << ". " << s << '\n';
			} else {
				// kui grupis on mitu osalejat, siis jagavad nii mitut kohta
				cout << koht << ".-" << koht + suurus - 1 << ". " << s << '\n';
			}
		}

		// eemaldame väljastatud osalejad nimekirjast
		vector<pair<int, string>> uus_tabel;
		for (const auto & [p, s] : tabel) {
			if (p != skoor) {
				uus_tabel.push_back(make_pair(p, s));
			}
		}
		tabel = uus_tabel;

		// järgmine koht on selle grupi suuruse võrra edasi
		koht += suurus;
	}
}
