// ebaefektiivne lahendus tulemuste nimekirja korduva läbikammimise abil
// kasutab käsitsi kirjutatud korduste asemel standardteegi vahendeid

#include <iostream>
#include <string>
#include <vector>
#include <utility>
#include <algorithm>
#include <ranges>
using namespace std;

int main() {
	// loeme osalejate arvu
	int n;
	cin >> n;

	// teeme loendi, mille elemendid on punktisumma/kasutajanimi paarid
	vector<pair<int, string>> tabel(n);
	for (auto & [p, s] : tabel) {
		// loeme osaleja nime ja punktisumma
		cin >> s >> p;
	}

	int koht = 1; // alustame 1. koha väljastamisest

	// kuni on veel osalejaid, leiame ja väljastame suurima punktisummaga grupi
	while (tabel.size() > 0) {
		// esimese läbimisega leiame suurima punktisumma
		auto skoor = ranges::max(tabel
			| views::transform([](const auto & x) { return x.first; }));

		// teise läbimisega leiame selle punktisummaga osalejate grupi
		auto grupp = tabel
			| views::filter([skoor](const auto & x) { return x.first == skoor; })
			| views::transform([](const auto & x) { return x.second; });

		// väljastame osalejate grupi
		const int suurus = ranges::distance(grupp);
		for (const auto & s : grupp) {
			if (suurus == 1) {
				// kui grupis on üks osaleja, siis kohtade jagamist ei ole
				cout << koht << ". " << s << '\n';
			} else {
				// kui grupis on mitu osalejat, siis jagavad nii mitut kohta
				cout << koht << ".-" << koht + suurus - 1 << ". " << s << '\n';
			}
		}

		// eemaldame väljastatud osalejad nimekirjast
		erase_if(tabel, [skoor](const auto & x) { return x.first == skoor; });

		// järgmine koht on selle grupi suuruse võrra edasi
		koht += suurus;
	}
}
