﻿namespace Topsid
{
    class Program
    {
        public static void Main(string[] args)
        {
            if (args.Length > 0)
            {
                Console.WriteLine("Solving files...");
                SolveFiles();
            }
            else
            {
                SolveCommandLine();
            }
        }

        private static void SolveFiles()
        {
            int i = 0;
            while (File.Exists($"input{i}.txt"))
            {
                SolveFile(i);
                i++;
            }
        }

        private static void SolveFile(int i)
        {
            var s = File.ReadAllLines($"input{i}.txt").ToList();
            var res = Solve(s);
            File.WriteAllText($"output{i}.txt", $"{res}" + Environment.NewLine);
        }

        private static void SolveCommandLine()
        {
            List<string> s = new List<string> { Console.ReadLine() };
            int n = StringToInts(s[0])[1];
            for (int i = 0; i < n; i++)
            {
                s.Add(Console.ReadLine());
            }

            Console.WriteLine(Solve(s));
        }

        private static int Solve(List<string> s)
        {
            int m, n, p;
            int[] input = StringToInts(s[0]);
            (n, m, p) = (input[0], input[1], input[2]);

            for (int i = 0; i < m; i++)
            {
                var ab = StringToInts(s[i + 1]);
                int a = ab[0], b = ab[1];
                if (a == p) p = b;
                else if (b == p) p = a;
            }

            return p;
        }

        private static int[] StringToInts(string s)
        {
            return s.Split().Select(int.Parse).ToArray();
        }
    }
}
