import random

def seq_spaced(w, n):
    sw = max(3, w // n)
    xs = [random.randint(1, sw)]
    for _ in range(n - 1):
        xs.append(xs[-1] + random.randint(3, sw))
    return xs

def gen(seed, h, w, n):
    random.seed("elding" + seed)
    
    starts = seq_spaced(w, n)
    ends = seq_spaced(w, n)
    
    
    points = []
    ends2 = []
    occupied = set()
    for i, (s, e) in enumerate(zip(starts, ends)):
        if i > 0:
            e = max(e, ends[i - 1] + 2)
        
        # Match the parity
        if (s + e + h) % 2 != 0:
            e += 1
        
        ends[i] = e
    
        curr_points = []
        y = h
        x = s
        while y > 0:
            curr_points.append((x, y))
            for dx in range(3):
                occupied.add((x + dx, y))
            
            if x + y <= e or (x - 1, y - 1) in occupied:
                x += 1
            else:
                x -= 1
            y -= 1 

        ends2.append(x)
        curr_points.append((x, y))
        
        points.append(curr_points)
        
    return starts, ends2, points

if __name__ == "__main__":
    import argparse
    parser = argparse.ArgumentParser()
    parser.add_argument("seed")
    for name in ["h", "w", "n"]:
        parser.add_argument(name, type=int)
        
    parser.add_argument("coefficients")
    parser.add_argument("in_file", type=argparse.FileType("w"))
    parser.add_argument("out_file", type=argparse.FileType("w"))
    
    args = parser.parse_args()
    
    starts, ends, points = gen(args.seed, args.h, args.w, args.n)
    terminals = []
    
    # Input
    print(len(starts), len(ends), len(terminals), args.h, file=args.in_file)
    print(" ".join(map(str, starts)), file=args.in_file)
    print(" ".join(map(str, ends)), file=args.in_file)
    print(" ".join(args.coefficients.split(",")), file=args.in_file)
    
    # Output
    for group in points:
        print(len(group), file=args.out_file)
        for x, y in group:
            print(x, y, file=args.out_file)
