import random

def try_gen(seed, h, w, n, split_p, terminate_p, k=None, m_lim=None):
    random.seed("elding" + seed)
    
    sw = max(2, w // n)
    starts = [random.randint(1, sw)]
    for _ in range(n - 1):
        starts.append(starts[-1] + random.randint(2, sw))

    heads = list(enumerate(starts))
    counts = [1 for _ in starts]

    points = [{(x, h)} for x in starts]
    
    terminals = []
    splits = 0
    for y in range(h)[::-1]:
        random.shuffle(heads)
        heads.sort(key=lambda ix: counts[ix[0]])
        
        new_heads = []
        occupied = set()
        # Eliminate ambiguity
        #    *
        #   * *
        #  * x *
        heads_s = sorted(x for _, x in heads)
        for x1, x2 in zip(heads_s, heads_s[1:]):
            if x2 == x1 + 2:
                occupied.add(x1 + 1)
            
        for i, x in heads:
            possible = [nx for nx in [x - 1, x + 1] if nx not in occupied]

            if ((counts[i] > 1 and random.random() < terminate_p)
                or len(possible) == 0):
                # Terminate
                terminals.append((x, y + 1, i))
                counts[i] -= 1
                if counts[i] <= 0:
                    # :(
                    return None
            elif len(possible) == 2 and random.random() < split_p:
                # Split
                counts[i] += 1
                splits += 1
                for nx in possible:
                    points[i].add((nx, y))
                    new_heads.append((i, nx))
                    for dx in range(-1, 2):
                        occupied.add(nx + dx)
            else:
                # Single
                nx = random.choice(possible)
                points[i].add((nx, y))
                new_heads.append((i, nx))
                for dx in range(-1, 2):
                    occupied.add(nx + dx)
        
        heads = new_heads
        prev_occupied = occupied
    
    prune = []
    
    heads = set(heads)
    if m_lim is not None:
        while len(heads) > m_lim:
            candidates = [(i, x) for i, x in heads if counts[i] > 1]
            i, x = random.choice(candidates)
            counts[i] -= 1
            heads.remove((i, x))
            prune.append((x, 0, i))
    
    if k is not None:
        random.shuffle(terminals)
        prune += terminals[k:]
        terminals = terminals[:k]
        
    for x, y, i in prune:
        while True:
            # Remove this point
            points[i].discard((x, y))
            
            # Find the parent point
            if (x - 1, y + 1) in points[i]:
                x, y = x - 1, y + 1
            else:
                x, y = x + 1, y + 1
            
            # Check whether we can stop pruning
            if any((x + dx, y - 1) in points[i] for dx in [-1, 1]):
                break

            
    ends = sorted(x for _, x in heads)
    
    shift = max(0, 1 - ends[0])
    starts = [x + shift for x in starts]
    ends = [x + shift for x in ends]
    points = [[(x + shift, y) for x, y in group] for group in points]
    
    return starts, ends, terminals, points

def gen(seed, *args):
    c = 0
    data = None
    while data is None:
        data = try_gen(seed + str(c), *args)
        c += 1
    
    return data

if __name__ == "__main__":
    import argparse
    parser = argparse.ArgumentParser()
    parser.add_argument("seed")
    for name in ["h", "w", "n"]:
        parser.add_argument(name, type=int)
    parser.add_argument("split_p", type=float)
    parser.add_argument("terminate_p", type=float)
    parser.add_argument("coefficients")
    parser.add_argument("in_file", type=argparse.FileType("w"))
    parser.add_argument("out_file", type=argparse.FileType("w"))
    parser.add_argument("-k", type=int)
    parser.add_argument("-m", type=int)
    
    args = parser.parse_args()
    
    starts, ends, terminals, points = gen(args.seed, args.h, args.w, args.n, args.split_p, args.terminate_p, args.k, args.m)
    
    # Input
    print(len(starts), len(ends), len(terminals), args.h, file=args.in_file)
    print(" ".join(map(str, starts)), file=args.in_file)
    print(" ".join(map(str, ends)), file=args.in_file)
    print(" ".join(args.coefficients.split(",")), file=args.in_file)
    
    # Output
    for group in points:
        print(len(group), file=args.out_file)
        for x, y in group:
            print(x, y, file=args.out_file)
