import random

def seq_spaced(w, n):
    sw = max(3, w // n)
    xs = [random.randint(1, sw)]
    for _ in range(n - 1):
        xs.append(xs[-1] + random.randint(3, sw))
    return xs

def gen(seed, h, w, n, split_p, terminate_p, k, m_max):
    random.seed("elding" + seed)
    
    starts = seq_spaced(w, n)
    
    points = []
    ends2 = []
    occupied = set()
    counts = []
    bi = 0
    terminals = []
    for s in starts:
        curr_points = set()
        y = h
        curr_xs = [s]
        count = 1
        while y > 0:
            new_xs = []
            curr_xs.sort()
            for i in range(len(curr_xs) - 1):
                x1 = curr_xs[i]
                x2 = curr_xs[i + 1]
                if x2 == x1 + 2:
                    occupied.add((x1 + 1, y - 1))
            
            random.shuffle(curr_xs)
            count -= len(curr_xs)
            for x in curr_xs:
                curr_points.add((x, y))
                for dx in range(3):
                    occupied.add((x + dx, y))
                
                candidates = [nx for nx in [x - 1, x + 1] if (nx, y - 1) not in occupied]
                if len(candidates) == 2 and random.random() < split_p:
                    # split
                    new_xs.append(x - 1)
                    new_xs.append(x + 1)
                    count += 2
                elif count > 0 and random.random() < terminate_p or len(candidates) == 0:
                    # terminate
                    terminals.append((x, y, bi))
                else:
                    # single
                    nx = random.choice(candidates)
                    count += 1
                    new_xs.append(nx)
                    
            y -= 1
            curr_xs = new_xs
            
        for x in curr_xs:
            curr_points.add((x, y))
            ends2.append((bi, x))

        points.append(curr_points)
        counts.append(count)
        bi += 1
    
    prune = []
    ends2 = set(ends2)
    if m_max is not None:
        while len(ends2) > m_max:
            candidates = [(i, x) for i, x in ends2 if counts[i] > 1]
            i, x = random.choice(candidates)
            counts[i] -= 1
            ends2.remove((i, x))
            prune.append((x, 0, i))
    
    if k is not None:
        random.shuffle(terminals)
        prune += terminals[k:]
        terminals = terminals[:k]
    
    for x, y, i in prune:
        while True:
            # Remove this point
            points[i].remove((x, y))
            
            # Find the parent point
            if (x - 1, y + 1) in points[i]:
                x, y = x - 1, y + 1
            else:
                x, y = x + 1, y + 1
            
            # Check whether we can stop pruning
            if any((x + dx, y - 1) in points[i] for dx in [-1, 1]):
                break
    ends = sorted(x for _, x in ends2)
    
    shift = max(0, 1 - ends[0])
    starts = [x + shift for x in starts]
    ends = [x + shift for x in ends]
    points = [[(x + shift, y) for x, y in group] for group in points]
    return starts, ends, terminals, points

if __name__ == "__main__":
    import argparse
    parser = argparse.ArgumentParser()
    parser.add_argument("seed")
    for name in ["h", "w", "n"]:
        parser.add_argument(name, type=int)
    parser.add_argument("split_p", type=float)
    parser.add_argument("terminate_p", type=float)
    parser.add_argument("coefficients")
    parser.add_argument("in_file", type=argparse.FileType("w"))
    parser.add_argument("out_file", type=argparse.FileType("w"))
    parser.add_argument("-k", type=int)
    parser.add_argument("-m", type=int)
    
    args = parser.parse_args()
    
    starts, ends, terminals, points = gen(args.seed, args.h, args.w, args.n, args.split_p, args.terminate_p, args.k, args.m)
    
    # Input
    print(len(starts), len(ends), len(terminals), args.h, file=args.in_file)
    print(" ".join(map(str, starts)), file=args.in_file)
    print(" ".join(map(str, ends)), file=args.in_file)
    print(" ".join(args.coefficients.split(",")), file=args.in_file)
    
    # Output
    for group in points:
        print(len(group), file=args.out_file)
        for x, y in group:
            print(x, y, file=args.out_file)
