import subprocess
import os
from pathlib import Path
from time import time_ns

gen = Path(os.path.dirname(os.path.realpath(__file__)))

root = gen / ".."

for i in range(11):
    print(str(i).ljust(4, "."), end="", flush=True)

    in_file = root / "input" / f"input{i}.txt"
    out_file = root / "output" / f"output{i}.txt"
    start = time_ns()
    r = subprocess.run(
        ["pypy3", root / "check" / "checker", in_file, out_file, out_file],
        capture_output=True    
    )
    dt = time_ns() - start
    if r.returncode != 0 or float(r.stdout.decode()) <= 0.0:
        msg = "FAIL"
    else:
        msg = "OK"
    print(msg, f"{dt / 1e9:>6.3f} s", r.stdout.decode().strip())
    