
import argparse

parser = argparse.ArgumentParser()
parser.add_argument("segments", type=int)
parser.add_argument("-l", "--per-length", action="store_true")

args = parser.parse_args()


counts = [0]
for _ in range(args.segments):
    best = (1e100, 0)
    for i in range(1, len(counts) + 1):
        curr_count = 0
        if i < len(counts):
            curr_count = counts[i]
        score = i**2 * 2 + (curr_count + 1)**2 - curr_count**2
        if args.per_length:
            score /= i
        best = min(best, (score, i))
    
    _, l = best
    
    if l >= len(counts):
        counts.append(1)
    else:
        counts[l] += 1

print(counts)

import matplotlib.pyplot as plt

plt.plot(list(range(1, len(counts))), counts[1:])

ax = plt.gca()

ax.set_xlabel("Lõigu pikkus")
ax.set_ylabel("Esinemisi")


plt.gcf().set_size_inches(5, 3.5)
plt.show()
