import sys
import copy
import itertools
from itertools import combinations
from collections import Counter
from bisect import bisect_left
from math import dist
from time import time
import random

max_time = 10**9
if len(sys.argv) > 1:
    max_time = int(sys.argv[1])

n, m, k, h = map(int, input().split())
starts = list(map(int, input().split()))
ends = list(map(int, input().split()))
coefficients = list(map(float, input().split()))

def iter_ys(xys, h):
    cy = h
    for x, y in xys:
        while y != cy:
            cy -= 1
            yield None
        yield x, y

    while cy >= 0:
        cy -= 1
        yield None

def grade(points):
    INF = [1e30 for _ in range(5)]
    
    for group in points:
        group.sort(key=lambda xy: xy[1], reverse=True)
    
    iters = [iter_ys(group, h) for group in points]
    
    # Check the cloud line
    starts1 = []
    for it in iters:
        xy = next(it)
        if xy is None:
            return INF
        
        starts1.append(xy[0])

        xy = next(it)
        if xy is not None:
            return INF
    
    if starts1 != starts:
        return INF

    # Find all the splitting points, terminals, segments
    # and check the constraints
    splits = set()
    terminals = set()
    prev_xs = set(starts1)
    segments = [set() for _ in range(n)]
    prev_group_xs = [{x} for x in starts1]
    prev_segment_mem = {x: (0, (x, h)) for x in starts1}
    for y in range(h)[::-1]:
        xs = set()
        xs_i = []
        curr_group_xs = []
        segment_mem = {}
        for bi, (it, prev_g_xs) in enumerate(zip(iters, prev_group_xs)):
            group_xs = set()
            used_prev_xs = set()
            for xy in it:
                if xy is None:
                    break
                x, _ = xy
                
                if x in xs:
                    return INF
                
                if all(cx not in prev_g_xs for cx in [x - 1, x + 1]):
                    return INF
                
                if all(cx in prev_xs for cx in [x - 1, x + 1]):
                    return INF
                
                prev_x = next(cx for cx in [x - 1, x + 1] if cx in prev_xs)
                dx = x - prev_x
                end_prev = False
                if prev_x in used_prev_xs:
                    # Split
                    splits.add((prev_x, y + 1))
                    
                    segment_mem[x] = dx, (prev_x, y + 1)
                    
                    # Make sure the other point knows that it is
                    # in a new segment
                    ox = x - 2 * dx
                    segment_mem[ox] = -dx, (prev_x, y + 1)
                    end_prev = True
                else:
                    used_prev_xs.add(prev_x)
                    if prev_segment_mem[prev_x][0] not in [dx, 0] or (prev_x, y + 1) in splits:
                        # Turn / split
                        segment_mem[x] = dx, (prev_x, y + 1)
                        end_prev = True
                    else:
                        segment_mem[x] = dx, prev_segment_mem[prev_x][1]
                
                if end_prev:
                    # End the previous segment
                    seg_a = prev_segment_mem[prev_x][1]
                    seg_b = (prev_x, y + 1)
                    if seg_a != seg_b:
                        segments[bi].add((seg_a, seg_b))
                
                xs.add(x)
                xs_i.append((x, bi))
                group_xs.add(x)
            
            if len(group_xs) == 0:
                return INF
            
            for x in prev_g_xs - used_prev_xs:
                # Terminal
                terminals.add((x, y + 1))
                # Save the segment
                segments[bi].add((prev_segment_mem[x][1], (x, y + 1)))
            
            if y == 0:
                # End all of the segments on the ground
                for x in group_xs:
                    segments[bi].add((segment_mem[x][1], (x, y)))
            
            curr_group_xs.append(group_xs)
        
        xs_i.sort()
        for i in range(len(xs_i) - 1):
            x0, bi0 = xs_i[i]
            x1, bi1 = xs_i[i + 1]
            if bi0 != bi1 and x1 - x0 < 2:
                return INF
        
        prev_xs = xs
        prev_group_xs = curr_group_xs
        prev_segment_mem = segment_mem
        
        if n + len(splits) > m + k:
            return INF

    if len(terminals) != k:
        return INF
    
    if len(prev_xs) != m:
        return INF
        
    if prev_xs != set(ends):
        return INF

    cost_a = 0
    cost_b = 0
    for seg in segments:
        count = Counter()
        for (_, y0), (_, y1) in seg:
            dy = y0 - y1
            cost_a += 2 * dy**2
            count[dy] += 1
        cost_b += sum(c**2 for c in count.values())
    
    cost_c = 0.0
    iters = [iter_ys(group, h) for group in points]
    lows = [low for seg in segments for _, low in seg]
    lows.sort(key=lambda xy: xy[1], reverse=True)
    iter_points = iter_ys(lows, h)
    for y in range(h + 1)[::-1]:
        xs = []
        for it in iters:
            for xy in it:
                if xy is None:
                    break
                x, _ = xy
                xs.append(x)
        xs.sort()
        for xy in iter_points:
            if xy is None:
                break
            x, _ = xy
            ci = bisect_left(xs, x)
            d = 10**9

            if ci > 0:
                d = min(d, x - xs[ci - 1])
            if ci + 1 < len(xs):
                d = min(d, xs[ci + 1] - x)
            cost_c += 1 / d**2
    
    cost_d = sum(1 / y for _, y in terminals)
    cost_e = 0.0
    terminals_l = list(terminals)
    for xy1, xy2 in combinations(terminals_l, 2):
        d = dist(xy1, xy2)
        cost_e += (d - 10)**2 / d**4
    
    return cost_a, cost_b, cost_c, cost_d, cost_e


def evaluate(g):
    return sum(a * b for a, b in zip(coefficients, g))


class Timeout(Exception):
    pass

best_g = 1e40
best_points = None
def rec_solve(points, xs, y, ct, cs, counts):
    global best_g, best_points
    if y < 0:
        xs2 = set(x for x, _ in xs)
        g = evaluate(grade(points))
        if g < best_g:
            print(g, file=sys.stderr)
            best_g = g
            best_points = copy.deepcopy(points)
        if time() - start_t > max_time:
            raise Timeout()
    else:
        bads = set()
        xs_s = sorted(xs)
        for i in range(len(xs_s) - 1):
            x1 = xs_s[i][0]
            x2 = xs_s[i + 1][0]
            if x2 == x1 + 2:
                bads.add(x1 + 1)
        
        # Consider all of the options for the current head
        # terminate, left, right, split
        opts_l = itertools.product(range(4), repeat=len(xs))
        if y > 2 and len(xs) <= 8:
            opts_l = list(opts_l)
            random.shuffle(opts_l)
        for opts in opts_l:
            occupied = set()
            ct2 = ct
            cs2 = cs
            xs2 = []
            counts2 = counts.copy()
            for o, (x, i) in zip(opts, xs_s):
                counts2[i] -= 1
                if o == 0:
                    ct2 += 1
                    if counts2[i] <= 0:
                        break
                if o & 1:
                    # left
                    nx = x - 1
                    if nx in bads or nx in occupied:
                        break
                    points[i].append((nx, y))
                    xs2.append((nx, i))
                    occupied.add(nx)
                    occupied.add(nx - 1)
                    occupied.add(nx + 1)
                    counts2[i] += 1
                if o & 2:
                    # right
                    nx = x + 1
                    if nx in bads or nx in occupied:
                        break
                    points[i].append((nx, y))
                    xs2.append((nx, i))
                    occupied.add(nx)
                    occupied.add(nx - 1)
                    occupied.add(nx + 1)
                    counts2[i] += 1
                if o == 3:
                    cs2 += 1
            else:
                if cs2 + n > m + k or ct2 > k:
                    # too many splits / terminals
                    pass
                else:
                    # ok
                    rec_solve(points, xs2, y - 1, ct2, cs2, counts2)
                
            # remove the added points
            for ps in points:
                while ps[-1][1] == y:
                    ps.pop()
                

start_t = time()
random.seed(312)
try:
    rec_solve([[(x, h)] for x in starts], [(x, i) for i, x in enumerate(starts)], h - 1, 0, 0, [1 for _ in starts])
except (Timeout, KeyboardInterrupt):
    pass

print(evaluate(grade(best_points)), file=sys.stderr)

for ps in best_points:
    print(len(ps))
    for x, y in ps:
        print(x, y)

