import cv2
import numpy as np
import argparse

parser = argparse.ArgumentParser()
parser.add_argument("in_file", type=argparse.FileType("r"))
parser.add_argument("out_file", type=argparse.FileType("r"))
parser.add_argument("--no-out", action="store_true")
parser.add_argument("--no-show", action="store_true")
parser.add_argument("--out", default="img.png")
parser.add_argument("--max-width", type=int, default=1800)
parser.add_argument("--max-height", type=int, default=1000)
parser.add_argument("--native", action="store_true")

args = parser.parse_args()

n, m, k, h = map(int, args.in_file.readline().split())

points = []

mxx = 0
mix = 0
for _ in range(n):
    for _ in range(int(args.out_file.readline())):
        x, y = map(int, args.out_file.readline().split())
        points.append((x, y))
        mxx = max(mxx, x)
        mix = min(mix, x)

mix -= 1
mxx += 1
img = np.zeros((h + 1, mxx + 1 - mix, 3), dtype=np.uint8)

# ruler
ruler = 10
for y in range(img.shape[0]):
    for x in range(img.shape[1]):
        img[y,x] = [(100, 0, 0), (0, 0, 100)][(y // ruler + x // ruler) % 2]

for x, y in points:
    img[h - y][x - mix][:] = 255

if not args.native:
    scale = 1 / max(img.shape[0] / args.max_height, img.shape[1] / args.max_width)
    img = cv2.resize(img, None, fx=scale, fy=scale, interpolation=cv2.INTER_NEAREST if scale > 1 else cv2.INTER_LINEAR)

if not args.no_out:
    cv2.imwrite(args.out, img)

if not args.no_show:
    cv2.imshow("Image", img)

    while True:
        if (cv2.waitKey(1) & 0xff) == ord("q"):
            break

    cv2.destroyAllWindows()

