import argparse

parser = argparse.ArgumentParser()
parser.add_argument("input", type=argparse.FileType("r"))
parser.add_argument("output", type=argparse.FileType("r"))

args = parser.parse_args()
input, output = args.input, args.output

h = int(input.readline().split()[-1])
starts = list(map(int, input.readline().split()))
ends = list(map(int, input.readline().split()))

all_points = []
for _ in starts:
    num = int(output.readline())
    points = [tuple(map(int, output.readline().split())) for _ in range(num)]
    points.sort(key=lambda p: -p[1])
    all_points.append(points)

minx = min(x for points in all_points for x, _ in points) - 1
maxx = max(x for points in all_points for x, _ in points) + 1

print(fr"\fill[fill=lightgray!10] ({minx}, {h}) rectangle ({maxx}, 0);")
print(fr"\draw[lightgray] ({minx}, {h}) grid ({maxx}, 0);")

print(fr"\draw[line width=1mm, green!80!black] ({minx}, 0) to ({maxx}, 0);")

print(fr"\coordinate (A) at (0, {h});")
print(fr"\coordinate (B) at ({max(starts)+1}, {h});")
print(r"\node[rounded rectangle, fit=(A) (B), draw, fill=gray, inner sep=0, minimum height=0.6cm] {};")

print(r"\newcommand{\visstart}[2]{\node[circle,draw,fill=white,inner sep=1mm] at (#1, #2) {\tiny #1}}")
print(r"\newcommand{\visend}[2]{\node[circle, blue, fill, minimum size=5, inner sep=0] at (#1, #2) {}}")
print(r"\newcommand{\visline}[2]{\draw[line width=0.8mm, yellow!85!black] #1 to #2}")

for start, points in zip(starts, all_points):
    prevs = set()
    used = set()
    for x, y in points:
        prev = None
        for dx in [-1, 1]:
            if (x + dx, y + 1) in prevs:
                prev = (x + dx, y + 1)
                break
        
        if prev is not None:
            used.add(prev)
            print(r"\visline{" f"({prev[0]}, {prev[1]})" "}{" f"({x}, {y})" "};")
        prevs.add((x, y))
    print(r"\visstart{" f"{start}" "}{" f"{h}" "};")
    for x, y in prevs - used:
        print(r"\visend{"f"{x}" "}{" f"{y}" "};")
