
# ~~ ChatGPT

import argparse
import cv2
import numpy as np

def slice_and_stack(image_path, target_height, separator_width, output_path):
    # Read image
    img = cv2.imread(image_path)
    if img is None:
        raise ValueError(f"Could not load image: {image_path}")

    h, w, c = img.shape

    # Slice image vertically into parts
    slices = []
    for y in range(0, h, target_height):
        slice_img = img[y:y + target_height, :]
        slices.append(slice_img)

    # Create black separator
    separator = np.zeros((target_height, separator_width, c), dtype=np.uint8)

    # Resize all slices to have the same height (pad last if shorter)
    max_height = target_height
    for i in range(len(slices)):
        sh = slices[i].shape[0]
        if sh < max_height:
            pad = np.zeros((max_height - sh, w, c), dtype=np.uint8)
            slices[i] = np.vstack([slices[i], pad])

    # Interleave slices and separators
    stacked = slices[0]
    for s in slices[1:]:
        stacked = np.hstack([stacked, separator, s])

    # Save result
    cv2.imwrite(output_path, stacked)
    print(f"Saved stacked image to {output_path}")


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Slice a tall image into sections and stack them side by side.")
    parser.add_argument("input", help="Path to input image")
    parser.add_argument("target_height", type=int, help="Target slice height")
    parser.add_argument("separator_width", type=int, help="Width of black separator between slices")
    parser.add_argument("output", help="Path to save the output image")

    args = parser.parse_args()

    slice_and_stack(args.input, args.target_height, args.separator_width, args.output)
