// O(N^3) lahendus Floyd-Warshalli algoritmiga

#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

int main() {
	int n, x, y;
	cin >> n >> x >> y;
	--x; --y;

	// konstrueerime graafi
	auto d = vector(n, vector(n, n));
	for (int i = 0; i < n; ++i) {
		d[i][i] = 0;
	}
	for (int i = 1; i < n; ++i) {
		d[i-1][i] = d[i][i-1] = 1;
	}
	d[x][y] = d[y][x] = 1;

	// leiame kõik kaugused Floyd-Warshalli algoritmiga
	for (int k = 0; k < n; ++k) {
		for (int i = 0; i < n; ++i) {
			for (int j = 0; j < n; ++j) {
				d[i][j] = min(d[i][j], d[i][k] + d[k][j]);
			}
		}
	}

	// koostame vastuse
	auto v = vector(n, 0);
	for (int j = 0; j < n; ++j) {
		for (int i = 0; i < j; ++i) {
			++v[d[i][j]];
		}
	}

	// väljastame vastuse
	for (int i = 1; i < n; ++i) {
		cout << v[i] << '\n';
	}
}
