# O(N^3) lahendus Floyd-Warshalli algoritmiga

n, x, y = (int(i) for i in input().split())
x, y = x - 1, y - 1

# konstrueerime graafi
d = [[n for j in range(n)] for i in range(n)]
for i in range(n):
    d[i][i] = 0
for i in range(1, n):
    d[i-1][i] = 1
    d[i][i-1] = 1
d[x][y] = 1
d[y][x] = 1

# leiame kõik kaugused Floyd-Warshalli algoritmiga
for k in range(n):
    for i in range(n):
        for j in range(n):
            d[i][j] = min(d[i][j], d[i][k] + d[k][j])

# koostame vastuse
v = [0 for i in range(n)]
for j in range(n):
    for i in range(j):
        v[d[i][j]] += 1

# väljastame vastuse
for i in range(1, n):
    print(v[i])
