// O(N^2) lahendus

#include <iostream>
#include <vector>
#include <queue>
using namespace std;

bool in_bounds(const vector<vector<int>> &t, int r, int c) {
	return r >= 0 and r < t.size() and c >= 0 and c < t[r].size();
}

int main() {
	int n, x, y;
	cin >> n >> x >> y;

	const int r0 = abs(x - y);
	const int c0 = min(x, y) - 1;

	vector<vector<int>> dist(n);
	for (int r = 0; r < n; ++r) {
		dist[r].resize(n - r, r);
	}
	dist[r0][c0] = 1;

	queue<pair<int, int>> q;
	q.push({r0, c0});
	while (!q.empty()) {
		const auto [r, c] = q.front(); q.pop();
		const int d = dist[r][c] + 1;
		const vector<pair<int, int>> pairs = {{r - 1, c}, {r - 1, c + 1}, {r + 1, c - 1}, {r + 1, c}};
		for (const auto [nr, nc] : pairs) {
			if (in_bounds(dist, nr, nc) and dist[nr][nc] > d) {
				dist[nr][nc] = d;
				q.push({nr, nc});
			}
		}
	}

	vector<int> ans(1 + n);
	for (const auto & row : dist) {
		for (const auto & x : row) {
			++ans[x];
		}
	}

	for (int k = 1; k < n; ++k) {
		cout << ans[k] << '\n';
	}
}
