# O(N^2) lahendus

from collections import deque

def in_bounds(t, r, c):
    return 0 <= r < len(t) and 0 <= c < len(t[r])

if __name__ == '__main__':
    N, X, Y = map(int, input().split())

    r0 = abs(X - Y)
    c0 = min(X, Y) - 1

    dist = [[r for _ in range(N - r)] for r in range(N)]
    dist[r0][c0] = 1

    q = deque()
    q.append((r0, c0))
    while q:
        r, c = q.popleft()
        d = dist[r][c] + 1

        for nr, nc in [
            (r-1, c),
            (r-1, c+1),
            (r+1, c-1),
            (r+1, c),
        ]:
            if in_bounds(dist, nr, nc) and dist[nr][nc] > d:
                dist[nr][nc] = d
                q.append((nr, nc))

    ans = [0] * (N+1)
    for row in dist:
        for x in row:
            ans[x] += 1

    for k in range(1, N):
        print(ans[k])
