#include <iostream>
#include <fstream>
#include <cctype>
#include <cstdlib>
#include <optional>
using namespace std;

#define done(r, m) (cout << r << '\n', cerr << m << '\n', exit(0))

optional<long long> read(istream & is) {
	const long long mod = 1ll << 31;
	long long val = 0;
	bool neg = false;
	int count = 0;
	for (char c; is >> c; ++count) {
		if (c == '-' and count == 0) {
			neg = true;
		} else if (isdigit(c)) {
			val = (10 * val + (c - '0')) % mod;
		} else {
			return nullopt;
		}
	}
	if (count == 0) {
		return nullopt;
	}
	if (val > 0 and neg) {
		val = mod - val;
	}
	return val;
}

int main(int argc, const char *argv[]) {
	if (argc != 4) {
		done(0, "Usage: " << argv[0] << " input hint output");
	}

	//ifstream in(argv[1]);
	ifstream hint(argv[2]);
	ifstream out(argv[3]);

	auto cor = read(hint);
	auto ans = read(out);

	if (!ans.has_value()) {
		done(0, "Invalid format");
	} else if (ans.value() != cor.value()) {
		done(0, "Wrong answer");
	} else {
		done(1, "OK");
	}
}
