#!/usr/bin/env python3

# Input validator

import sys
import re

pin = re.compile('[0-9]+')
pin01 = re.compile('0*1*')

st = set(range(1, 6))

fi = open(sys.argv[1], 'rt')
fo = open(sys.argv[2], 'wt')

n, m = (int(i) for i in fi.readline().split())
if 1 > n or n > 1_000:
    sys.exit(f'N out of range')
if 1 > m or m > 10_000:
    sys.exit(f'M out of range')
print(n, m, file=fo)
if n > 20 or m > 20:
    st.discard(3)

s = fi.readline().strip()
if len(s) != m:
    sys.exit(f'Invalid length of S')
if not pin.match(s):
    sys.exit(f'Invalid S')
print(s, file=fo)
if not pin01.match(s):
    st.discard(2)

# conditions of subtask 1 and 4 need the answer
rep = []
for i in range(len(s)):
    if i == 0 or s[i] != s[i - 1]:
        rep.append(1)
    else:
        rep[-1] += 1
avail = n - len(rep)
if avail > 0:
    dp = [[0 for _ in range(1 + avail)] for _ in range(1 + len(rep))]
    dp[0][0] = 1
    for i in range(1, len(dp)):
        for j in range(len(dp[i])):
            for k in range(min(j + 1, rep[i - 1])):
                dp[i][j] += dp[i - 1][j - k]
    k = dp[-1][-1]
    if k > 1:
        st.discard(1)
    if k >= 2**31:
        st.discard(4)

fi.close()
fo.close()

if len(sys.argv) > 4 and sys.argv[4].startswith('-v'):
    print('subtasks:', *st)
