#!/usr/bin/env python3

# Input validator

import sys

st = set(range(1, 3))

fi = open(sys.argv[1], 'rt')
fo = open(sys.argv[2], 'wt')

n, m = (int(i) for i in fi.readline().split())
if 1 > n or n > 200_000:
    sys.exit(f'N out of range')
if 1 > m or m > 200_000:
    sys.exit(f'M out of range')
print(n, m, file=fo)
if n > 100 or m > 100:
    st.discard(1)

a = [int(i) for i in fi.readline().split()]
if len(a) != n:
    sys.exit(f'Wrong length of A')
if 1 > a[0]:
    sys.exit(f'A[1] too small')
for i in range(n - 1):
    if a[i] >= a[i + 1]:
        sys.exit(f'A[{i + 1}] too large')
if a[-1] > 1_000_000:
    sys.exit(f'A[N] too large')
print(*a, file=fo)

b = [int(i) for i in fi.readline().split()]
if len(b) != m:
    sys.exit(f'Wrong length of B')
if 1 > b[0]:
    sys.exit(f'B[1] too small')
for i in range(m - 1):
    if b[i] > b[i + 1]:
        sys.exit(f'B[{i + 1}] too large')
if b[-1] > 1_000_000:
    sys.exit(f'B[M] too large')
print(*b, file=fo)

fi.close()
fo.close()

if len(sys.argv) > 4 and sys.argv[4].startswith('-v'):
    print('subtasks:', *st)
