// efektiivne lahendus kahendotsimise abil
// kasutab kahendotsinguks enda kirjutatud funktsiooni

#include <iostream>
#include <vector>
using namespace std;

// leiab vähima sellise indeksi i, mille korral arvu x jadasse a
// elemendi a[i] ette lisamisega jääb jada a sorteerituks
// NB! töötab ainult eeldusel, et jada a on sorteeritud!
int lower_bound(const vector<int> & a, int x) {
	int i1 = 0, i2 = a.size();
	while (i1 < i2) {
		int im = (i1 + i2) / 2; // jagame, ümardades alla
		if (a[im] < x) {
			i1 = im + 1; // a[im] on liiga väike, x peab olema paremal pool
		} else {
			i2 = im; // x peab olema kas vasakul või täpselt im kohal
		}
	}
	return i1;
}

int main() {
	// loeme sisendi
	int n, m; // aukude ja punnide arvud
	cin >> n >> m;

	vector<int> a(n); // aukude suurused
	for (auto & x : a) {
		cin >> x;
	}

	vector<int> b(m); // punnide suurused
	for (auto & x : b) {
		cin >> x;
	}

	// leiame ja väljastame vastuse
	for (int i = 0; i < m; ++i) { // vaatame läbi kõik punnid
		int j = lower_bound(a, b[i]); // leiame punnile i sobiva augu
		if (j == n) {
			cout << -1 << "\n"; // tegelikult piisavalt suurt auku ei ole
		} else {
			cout << j + 1 << "\n"; // vastuses on aukude numbrid 1..N
		}
	}
}
