#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <vector>
#include <cmath>
#include <signal.h>
using namespace std;

#define MAXPEGS 200000
#define MAXHOLES 200000
#define BUF (MAXPEGS * 7) // MAXPEGS * (len(MAXHOLES) + 1)

char buf[BUF];

int done(double res, const char * msg) {
	cout << res << '\n';
	cerr << msg << '\n';
	return 0;
}

int main(int argc, char *argv[]) {
	signal(SIGPIPE, SIG_IGN);
	ofstream to_sol(argv[2]);
	ifstream from_sol(argv[1]);

	// input
	int n_holes, n_pegs, g_rule; cin >> n_holes >> n_pegs >> g_rule;
	vector<int> holes(n_holes); for (auto & h : holes) cin >> h;
	vector<int> pegs(n_pegs); for (auto & p : pegs) cin >> p;

	// correct answer
	vector<int> correct(n_pegs);
	for (int peg = 0, hole = 0; peg < n_pegs; ++peg) {
		while (hole < n_holes and pegs[peg] > holes[hole]) ++hole;
		correct[peg] = hole == n_holes ? -1 : hole + 1;
	}

#if DEBUG > 1
	cerr << "--> " << n_holes << " " << n_pegs << "\n";
#endif
	to_sol << n_holes << " " << n_pegs << endl;
	if (!to_sol) {
		return done(0, "I/O error writing to program");
	}
	for (int q_count = 0; ; ++q_count) {
		from_sol.getline(buf, sizeof(buf));
		if (!from_sol) {
			return done(0, "I/O error reading from program");
		}
#if DEBUG > 1
	cerr << "<-- " << buf << "\n";
#endif
		istringstream is(buf);
		char q_type; is >> q_type;
		if (!is) {
			return done(0, "Empty input from program");
		}
		if (q_type == '?') { // query
			int peg, hole; is >> peg >> hole;
			if (!is) {
				return done(0, "Invalid query: format error");
			}
			char c; is >> c;
			if (!is.eof()) {
				return done(0, "Invalid query: format error");
			}
			if (1 > peg or peg > n_pegs or 1 > hole or hole > n_holes) {
				return done(0, "Invalid query: index out of range");
			}
			int res = holes[hole - 1] >= pegs[peg - 1];
#if DEBUG > 1
			cerr << "--> " << res << "\n";
#endif
			to_sol << res << endl;
			if (!to_sol) {
				return done(0, "I/O error writing to program");
			}
		} else if (q_type == '!') { // answer
			vector<int> answer(n_pegs); for (auto & a : answer) is >> a;
			if (!is) {
				return done(0, "Invalid answer: format error");
			}
			char c; is >> c;
			if (!is.eof()) {
				return done(0, "Invalid answer: format error");
			}
			if (answer != correct) {
				return done(0, "Wrong answer");
			}
			double p;
			switch (g_rule) {
				case 0:
					p = q_count;
					break;
				case 1:
					p = n_pegs * n_holes;
					break;
				case 2:
					p = n_pegs * log2(n_holes) * 100 / 99;
					break;
				case 3:
					p = log2(n_pegs) * n_holes * 100 / 99;
					break;
				case 4:
					p = fmin(n_pegs, n_holes) * log2(fmax(n_pegs, n_holes)) * 20 / 99;
					break;
				default:
					return done(0, "Invalid grading type! Alert the organizers!");
			}
			double r1 = p / fmax(1, q_count), r2 = fmin(1, r1);
#if DEBUG > 0
			cerr << "q = " << q_count << ", p = " << p << ", r1 = " << r1 << ", r2 = " << r2 << "\n";
#endif
			return done(r2, "OK");
		} else { // invalid
			return done(0, "Invalid query type");
		}
	}
}
