#!/usr/bin/env python3

# Input validator

import sys

st = set(range(0, 5))

fi = open(sys.argv[1], 'rt')
fo = open(sys.argv[2], 'wt')

n, m, s = (int(i) for i in fi.readline().split())
if 1 > n or n > 25_000:
    sys.exit(f'N out of range')
if 1 > m or m > 25_000:
    sys.exit(f'M out of range')
if 0 > s or s > 4:
    sys.exit(f'S out of range')
print(n, m, s, file=fo)
if n > 100 or m > 100:
    st.discard(1)
if m > 1000:
    st.discard(2)
if n > 1000:
    st.discard(3)

a = [int(i) for i in fi.readline().split()]
if len(a) != n:
    sys.exit(f'Wrong length of A')
if a != sorted(a):
    sys.exit(f'A not sorted')
if len(a) != len(set(a)):
    sys.exit(f'A not strictly sorted')
print(*a, file=fo)

b = [int(i) for i in fi.readline().split()]
if len(b) != m:
    sys.exit(f'Wrong length of B')
if b != sorted(b):
    sys.exit(f'B not sorted')
print(*b, file=fo)

fi.close()
fo.close()

if s not in st:
    sys.exit(f'Subtask mismatch')

if len(sys.argv) > 4 and sys.argv[4].startswith('-vv'):
    if len(b) != len(set(b)):
        print('B not strictly sorted')
if len(sys.argv) > 4 and sys.argv[4].startswith('-v'):
    print('subtasks:', *st)
