// lahendus kahekordse kahendotsingu abil
// sobib kõigile alamülesannetele

#include <iostream>
#include <vector>
using namespace std;

// leiab punnile i vastava augu j
// kasutab eeldust, et see peab olema [j1..j2)
int leia(int i, int j1, int j2) {
	while (j1 < j2) {
		int jm = (j1 + j2) / 2; // jagame, ümardades alla
		// proovime punni i auku jm
		cout << "? " << i + 1 << " " << jm + 1 << endl;
		int r;
		cin >> r;
		if (r == 0) {
			j1 = jm + 1; // auk jm on liiga väike, õige koht peab olema paremal pool
		} else {
			j2 = jm; // õige koht peab olema kas vasakul või täpselt jm kohal
		}
	}
	return j1;
}

vector<int> v; // vastuse hoidmise koht

// leiab õiged augud punnidele [i1..i2)
// kasutab eeldust, et need peavad olema [j1..j2)
void lahenda(int i1, int i2, int j1, int j2) {
	if (i1 < i2) {
		// leiame keskmise punni koha
		int im = (i1 + i2) / 2;
		v[im] = leia(im, j1, j2);
		// sellest vasakul olevate punnide kohad on ka vasakul
		lahenda(i1, im, j1, v[im]);
		// sellest paremal olevate punnide kohad on ka paremal
		lahenda(im + 1, i2, v[im], j2);
	}
}

int main() {
	// loeme aukude ja punnide arvud
	int n, m;
	cin >> n >> m;

	// leiame vastuse
	v.resize(m);
	lahenda(0, m, 0, n);
	
	// väljastame vastuse
	cout << "!";
	for (auto j : v) {
		if (j == n) {
			cout << " " << -1;
		} else {
			cout << " " << j + 1;
		}
	}
	cout << endl;
}
