﻿namespace Luud
{
    class Program
    {
        public static void Main(string[] args)
        {
            if (args.Length > 0)
            {
                Console.WriteLine("Solving files...");
                SolveFiles();
            }
            else
            {
                SolveStandardInput();
            }
        }

        private static void SolveFiles()
        {
            int i = 0;
            while (File.Exists($"input{i}.txt"))
            {
                Console.WriteLine($"input{i}.txt");
                SolveFile(i);
                i++;
            }
        }

        private static void SolveFile(int i)
        {
            var s = File.ReadAllText($"input{i}.txt");
            var mn = StringToInts(s);
            var res = Solve(mn[0], mn[1]);
            File.WriteAllText($"output{i}.txt", $"{res}" + Environment.NewLine);
        }

        private static void SolveStandardInput()
        {
            string s = Console.ReadLine();
            var mn = StringToInts(s);
            Console.WriteLine(Solve(mn[0], mn[1]));
        }

        private static int Solve(int m, int n)
        {
            if (Math.Min(m, n) == 2)
                return (Math.Max(m, n) + 2) / 3 * 2;
            return (m * n + 2) / 3;
        }

        private static int[] StringToInts(string s)
        {
            return s.Trim().Split().Select(int.Parse).ToArray();
        }
    }
}
