#!/usr/bin/env python3

# gen.py seed n w l max_abc is_cubes is_pyramidal

import sys
import random

seed = int(sys.argv[1])
n       = int(sys.argv[2])
w       = int(sys.argv[3])
l       = int(sys.argv[4])
max_abc = int(sys.argv[5])
is_cubes = sys.argv[6]
pyramidal_mode = sys.argv[7]

random.seed(seed + int.from_bytes(b'Friendship is Magic', byteorder='big') + 2630465137210429009)
if not (w <= l):
    print('ERROR!', file=sys.stderr)
    exit()
#print(*sys.argv, file=sys.stderr)

print(n, w, l)

if 'backwards' in pyramidal_mode:
    cur_l = l
    cur_w = w
    for i in range(n):
        done = i / n
        cur_l = max(1, cur_l - int(cur_l / n * (1 + 7 * done) * random.random()))
        cur_w = max(1, cur_w - int(cur_w / n * (1 + 7 * done) * random.random()))
        coin = random.random()
        mmin = min(cur_l, cur_w)
        mmax = max(cur_l, cur_w)
        if coin < 0.33:
            hh = int(random.random() * mmin)
        elif coin < 0.67:
            hh = mmin + int(random.random() * (mmax-mmin))
        else:
            hh = mmax + int(random.random() * (max_abc-mmax))
        hh = max(1, hh)
        dim = [cur_l, cur_w, hh]
        if 'true' in is_cubes:
            dim = [random.choice(dim)] * 3
        random.shuffle(dim)
        if random.random() < 0.2:
            for i in range(3):
                dim[i] = max(dim[i] // 4, 1)
        print(dim[0], dim[1], dim[2])
else:
    for i in range(n):
        coff = 0.1 * (n-i)/n if 'true' in pyramidal_mode else 1.0
        if 'false' in is_cubes:
            dim = [min(max(1, int(random.random() * coff * max_abc)), max_abc) for _ in range(3)]
        else:
            dim = min(max(1, int(random.random() * coff * max_abc)), max_abc)
            dim = [dim, dim, dim]
        print(dim[0], dim[1], dim[2])
