// Eukleidese algoritmiga lahendus

#include <iostream>
#include <cassert>
using namespace std;

const long long m = 1000000007;

// C++ a % m annab negatiivse a korral vale tulemuse
long long mod(long long a) {
	return (a % m + m) % m;
}

struct vorrand {
	long long x, y, z; // vorrandi kordajad
};

int main() {
	int q;
	cin >> q;
	while (q--) {
		long long a;
		cin >> a;
		// võrrandisüsteem
		vorrand v1{1, 0, a}; // a*1 + m*0 = a
		vorrand v2{0, 1, m}; // a*0 + m*1 = m
		// Eukleidese algoritm SÜT(a, m) leidmiseks
		while (v2.z > 0) { // while m > 0
			// a % m esitus kujul a - k*m
			long long k = v1.z / v2.z;
			// uue võrrandi kordajad
			vorrand v3{v1.x - k * v2.x, v1.y - k * v2.y, v1.z - k * v2.z};
			// viskame ühe vanematest võrranditest ära
			v1 = v2; v2 = v3;
		}
		// kui v2.z on 0, siis v1.z on SYT(a, m), mis peab olema 1
		assert(v1.z == 1);
		// siis on esimene võrrand kujul a*x + m*y = 1, kus x ongi otsitav pöördelement
		// sellel võrrandil on palju lahendeid, meil on vaja seda, kus 0 <= x < m
		cout << mod(v1.x) << '\n';
	}
}
