// Fermat' väikese teoreemiga lahendus

#include <iostream>
using namespace std;

const long long m = 1000000007;

// C++ a % m annab negatiivse a korral vale tulemuse
long long mod(long long a) {
	return (a % m + m) % m;
}

long long pow(long long a, long long k) {
	if (k == 1) {
		return mod(a);
	}
	long long t = pow(a, k / 2);
	if (k % 2 == 0) {
		return mod(t * t);
	}
	return mod(mod(t * t) * a);
}

int main() {
	int q;
	cin >> q;
	while (q--) {
		long long a;
		cin >> a;
		// sellel võrrandil on palju lahendeid, meil on vaja seda, kus 0 <= x < m
		cout << pow(a, m - 2) << '\n';
	}
}
