// Algarvude genereerimine väiksemate algarvudega jaguvuse kontrolliga

#include <iostream>
#include <vector>
using namespace std;

vector<int> primes{2};

bool isprime(int n) {
	if (n < 2) {
		return false;
	}
	for (auto p : primes) {
		if (p * p > n) {
			return true;
		}
		if (n % p == 0) {
			return false;
		}
	}
	return true;
}

void genprimes(int n) {
	for (int p = 3; p < n; p += 2) {
		if (p * p > n) {
			break;
		}
		if (isprime(p)) {
			primes.push_back(p);
		}
	}
}

int main() {
	genprimes(10000000);

	int q;
	cin >> q;
	while (q--) {
		long long p;
		cin >> p;
		if (isprime(p)) {
			cout << "JAH\n";
		} else {
			cout << "EI\n";
		}
	}
}
