// Algarvude genereerimine Eratosthenese sõelaga

// Genereerimine on natuke kiirem kui eelmises lahenduses
// Aga lõviosa programmi tööajast kulub isprime funktsioonis
// Kuna genprimes osakaal programmi tööajas on tühine, siis
// selle kiirendamine kogu tööaega sisuliselt ei mõjuta

#include <iostream>
#include <vector>
using namespace std;

vector<int> primes{2};

bool isprime(int n) {
	if (n < 2) {
		return false;
	}
	for (auto p : primes) {
		if (p * p > n) {
			return true;
		}
		if (n % p == 0) {
			return false;
		}
	}
	return true;
}

void genprimes(int n) {
	// kuhumaani on vaja algarve genereerida
	int m = 3;
	while (m * m <= n) {
		m += 1;
	}
	// sieve[i] näitab, kas i on algarv
	vector<bool> sieve(m, true);
	for (int i = 3; i < m; i += 2) {
		if (sieve[i]) {
			primes.push_back(i);
			for (int j = i * i; j < m; j += i) {
				sieve[j] = false;
			}
		}
	}
}

int main() {
	genprimes(10000000);

	int q;
	cin >> q;
	while (q--) {
		long long p;
		cin >> p;
		if (isprime(p)) {
			cout << "JAH\n";
		} else {
			cout << "EI\n";
		}
	}
}
