# Algarvude genereerimine Eratosthenese sõelaga

# Genereerimine on natuke kiirem kui eelmises lahenduses
# Aga lõviosa programmi tööajast kulub isprime funktsioonis
# Kuna genprimes osakaal programmi tööajas on tühine, siis
# selle kiirendamine kogu tööaega sisuliselt ei mõjuta

primes = [2]

def isprime(n):
    if n < 2:
        return False
    for p in primes:
        if p * p > n:
            return True
        if n % p == 0:
            return False
    return True

def genprimes(n):
    # kuhumaani on vaja algarve genereerida
    m = 3
    while m * m <= n:
        m += 1
    # sieve[i] näitab, kas i on algarv
    sieve = [True] * m
    for i in range(3, m, 2):
        if sieve[i]:
            primes.append(i)
            for j in range(i * i, m, i):
                sieve[j] = False

genprimes(10000000)

q = int(input())
for i in range(q):
    p = int(input())
    if isprime(p):
        print('JAH')
    else:
        print('EI')
