#!/usr/bin/env python3

import sys
import random
import itertools

random.seed(int(sys.argv[-1]))

def genuniq(s, n):
    if len(s) < 8:
        prm = [''.join(p) for p in set(itertools.permutations(s))]
        return random.sample(prm, n)
    buf = set()
    tmp = list(s)
    while len(buf) < n:
        random.shuffle(tmp)
        buf.add(''.join(tmp))
    return list(buf)

def genrep(s, n, m):
    tmp = genuniq(s, n)
    return tmp + random.choices(tmp, k = m - n)

res = []

if sys.argv[1] == '3a':
    # (tähekomplekt, arv) paarid
    for i in range(2, len(sys.argv) - 1, 2):
        res += genuniq(sys.argv[i], int(sys.argv[i + 1]))

if sys.argv[1] == '3b':
    # (tähekomplekt, unikaalsete arv, koguarv) kolmikud
    for i in range(2, len(sys.argv) - 1, 3):
        res += genrep(sys.argv[i], int(sys.argv[i + 1]), int(sys.argv[i + 2]))

if sys.argv[1] == '4a':
    # n, tähekomplekt, edasi (pikkus, arv) paarid
    n = int(sys.argv[2])
    while len(res) < n:
        for i in range(4, len(sys.argv) - 1, 2):
            s, m = sys.argv[3], int(sys.argv[i])
            if m < len(s):
                s = ''.join(random.sample(s, m))
            else:
                s += ''.join(random.choices(s, k = m - len(s)))
            res += genuniq(s, int(sys.argv[i + 1]))
    res = res[:n]

if sys.argv[1] == '4b':
    # n, tähekomplekt, edasi (pikkus, unikaalsete arv, koguarv) kolmikud
    n = int(sys.argv[2])
    while len(res) < n:
        for i in range(4, len(sys.argv) - 1, 3):
            s, m = sys.argv[3], int(sys.argv[i])
            if m < len(s):
                s = ''.join(random.sample(s, m))
            else:
                s += ''.join(random.choices(s, k = m - len(s)))
            res += genrep(s, int(sys.argv[i + 1]), int(sys.argv[i + 2]))
    res = res[:n]

random.shuffle(res)
print(len(res))
for s in res:
    print(s)
